/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.enums.Customize;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum LimitType {
    LOWER("0", "\u5c0f\u5199\u5b57\u6bcd", "a-z"),
    UPPER("1", "\u5927\u5199\u5b57\u6bcd", "A-Z"),
    NUMBER("2", "\u6570\u5b57", "0-9"),
    HEART_SYMBOL("3", "\u7231\u5fc3\u8868\u60c5", "(\\[\\[love\\]\\])*"),
    POINT_SYMBOL("4", "\u82f1\u6587\u70b9\u5b57\u7b26", "."),
    SMILE_SYMBOL("5", "\u7b11\u8138\u8868\u60c5", "(\\[\\[smile\\]\\])*"),
    ARROW_HEART_SYMBOL("6", "\u4e00\u7bad\u7a7f\u5fc3\u8868\u60c5", "(\\[\\[arrowheart\\]\\])*"),
    POINT_MIDDLE_SYMBOL("7", "\u82f1\u6587\u4e2d\u95f4\u70b9\u5b57\u7b26", "\u2022"),
    LB_PHONE_SYMBOL("8", "\u624b\u673a", "(\\[\\[lbphone\\]\\])*"),
    LB_BULB_SYMBOL("9", "\u706f\u6ce1", "(\\[\\[lbbulb\\]\\])*"),
    LB_AIRPLANE_SYMBOL("10", "\u98de\u673a", "(\\[\\[lbairplane\\]\\])*"),
    LB_SUNGLASSES_SYMBOL("11", "\u58a8\u955c", "(\\[\\[lbsunglasses\\]\\])*"),
    LB_FLASH_SYMBOL("12", "\u95ea\u7535", "(\\[\\[lbflash\\]\\])*"),
    LB_STAR_SYMBOL("13", "\u4e94\u89d2\u661f", "(\\[\\[lbstar\\]\\])*"),
    LB_BICYCLE_SYMBOL("14", "\u81ea\u884c\u8f66", "(\\[\\[lbbicycle\\]\\])*"),
    LB_BOY_SYMBOL("15", "\u7537\u5b69", "(\\[\\[lbboy\\]\\])*"),
    LB_GIRL_SYMBOL("16", "\u5973\u5b69", "(\\[\\[lbgirl\\]\\])*"),
    LB_OK_SYMBOL("17", "ok", "(\\[\\[lbok\\]\\])*"),
    BROMEL_SYMBOL("18", "\u9cf3\u68a8", "(\\[\\[bromel\\]\\])*");

    private String code;
    private String value;
    private String regEx;

    private LimitType(String code, String value, String regEx) {
        this.code = code;
        this.value = value;
        this.regEx = regEx;
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public String getRegEx() {
        return this.regEx;
    }

    public static LimitType getLimitTypeByCode(String code) {
        for (LimitType value : LimitType.values()) {
            if (!StringUtils.equals((CharSequence)value.getCode(), (CharSequence)code)) continue;
            return value;
        }
        return null;
    }

    public static List<LimitType> getLimitTypeByCodes(List<String> codes) {
        if (null == codes) {
            return null;
        }
        ArrayList limitTypes = Lists.newArrayList();
        for (String code : codes) {
            LimitType limitType = LimitType.getLimitTypeByCode(code);
            if (null == limitType) continue;
            limitTypes.add(limitType);
        }
        return limitTypes;
    }

    public static String getRegEx(List<LimitType> limitTypes) {
        boolean isHeartSymbol = false;
        boolean isSmileSymbol = false;
        boolean isArrowHeartSymbol = false;
        boolean isPhone = false;
        boolean isBulb = false;
        boolean isAirplane = false;
        boolean isSunglass = false;
        boolean isFlash = false;
        boolean isStar = false;
        boolean isBicycle = false;
        boolean isBoy = false;
        boolean isGirl = false;
        boolean isOk = false;
        boolean isBromel = false;
        StringBuffer regEx = new StringBuffer();
        StringBuffer regEx1 = new StringBuffer();
        for (LimitType limitType : limitTypes) {
            if (HEART_SYMBOL.equals((Object)limitType)) {
                isHeartSymbol = true;
                continue;
            }
            if (SMILE_SYMBOL.equals((Object)limitType)) {
                isSmileSymbol = true;
                continue;
            }
            if (ARROW_HEART_SYMBOL.equals((Object)limitType)) {
                isArrowHeartSymbol = true;
                continue;
            }
            if (LB_PHONE_SYMBOL.equals((Object)limitType)) {
                isPhone = true;
                continue;
            }
            if (LB_BULB_SYMBOL.equals((Object)limitType)) {
                isBulb = true;
                continue;
            }
            if (LB_AIRPLANE_SYMBOL.equals((Object)limitType)) {
                isAirplane = true;
                continue;
            }
            if (LB_SUNGLASSES_SYMBOL.equals((Object)limitType)) {
                isSunglass = true;
                continue;
            }
            if (LB_FLASH_SYMBOL.equals((Object)limitType)) {
                isFlash = true;
                continue;
            }
            if (LB_STAR_SYMBOL.equals((Object)limitType)) {
                isStar = true;
                continue;
            }
            if (LB_BICYCLE_SYMBOL.equals((Object)limitType)) {
                isBicycle = true;
                continue;
            }
            if (LB_BOY_SYMBOL.equals((Object)limitType)) {
                isBoy = true;
                continue;
            }
            if (LB_GIRL_SYMBOL.equals((Object)limitType)) {
                isGirl = true;
                continue;
            }
            if (LB_OK_SYMBOL.equals((Object)limitType)) {
                isOk = true;
                continue;
            }
            if (BROMEL_SYMBOL.equals((Object)limitType)) {
                isBromel = true;
                continue;
            }
            regEx1.append(limitType.getRegEx());
        }
        if (StringUtils.isNotEmpty((CharSequence)regEx1)) {
            regEx1.insert(0, "[");
            regEx1.append("]*");
        }
        regEx.append("^(");
        regEx.append(regEx1);
        if (isHeartSymbol) {
            regEx.append(HEART_SYMBOL.getRegEx());
        }
        if (isSmileSymbol) {
            regEx.append(SMILE_SYMBOL.getRegEx());
        }
        if (isArrowHeartSymbol) {
            regEx.append(ARROW_HEART_SYMBOL.getRegEx());
        }
        if (isPhone) {
            regEx.append(LB_PHONE_SYMBOL.getRegEx());
        }
        if (isBulb) {
            regEx.append(LB_BULB_SYMBOL.getRegEx());
        }
        if (isAirplane) {
            regEx.append(LB_AIRPLANE_SYMBOL.getRegEx());
        }
        if (isSunglass) {
            regEx.append(LB_SUNGLASSES_SYMBOL.getRegEx());
        }
        if (isFlash) {
            regEx.append(LB_FLASH_SYMBOL.getRegEx());
        }
        if (isStar) {
            regEx.append(LB_STAR_SYMBOL.getRegEx());
        }
        if (isBicycle) {
            regEx.append(LB_BICYCLE_SYMBOL.getRegEx());
        }
        if (isBoy) {
            regEx.append(LB_BOY_SYMBOL.getRegEx());
        }
        if (isGirl) {
            regEx.append(LB_GIRL_SYMBOL.getRegEx());
        }
        if (isOk) {
            regEx.append(LB_OK_SYMBOL.getRegEx());
        }
        if (isOk) {
            regEx.append(BROMEL_SYMBOL.getRegEx());
        }
        regEx.append(")*$");
        return regEx.toString();
    }
}

