package com.thebeastshop.support.vo.redenvelope;

import com.thebeastshop.support.enums.RedEnvelopeType;
import com.thebeastshop.support.vo.coupon.CouponVO;

import java.io.Serializable;

/**
 * Created by feilong.gao on 2016/12/22.
 */
public class ReceivedRedEnvelopeVo implements Serializable {

    private static final long serialVersionUID = -3396759976497015242L;
    private String type = RedEnvelopeType.COUPON.getValue();    //红包类型<COUPON|POINT>=COUPON
    private String desc;                                         //红包描述
    private String value;                                        //红包值
    private String name;                                         //红包名字
    private CouponVO coupon;                                    //优惠券详情

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CouponVO getCoupon() {
        return coupon;
    }

    public void setCoupon(CouponVO coupon) {
        this.coupon = coupon;
    }

    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("ReceivedRedEnvelopeVo{");
        sb.append("type='").append(type).append('\'');
        sb.append(", desc='").append(desc).append('\'');
        sb.append(", value='").append(value).append('\'');
        sb.append(", name='").append(name).append('\'');
        sb.append(", coupon=").append(coupon);
        sb.append('}');
        return sb.toString();
    }
}
