package com.thebeastshop.support.vo.order;

import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.market.MarketVipDTO;

/**
 * 预览订单DTO
 * 
 * @author Paul-xiong
 *
 */
public class OrderPreviewDTO {
	/**
	 * 购物车商品包列表
	 */
	private List<RequestPack> packs;

	/**
	 * 是否使用生日折扣
	 */
	private Boolean useBdayDiscount;

	/**
	 * 是否使积分兑换
	 */
	private Boolean usePointDeduct = Boolean.FALSE;

	/**
	 * 是否使用预存款
	 */
	private Boolean useAccountDeduct;

	/**
	 * 地址id
	 */
	private long addressId;
	/**
	 * 配送日期
	 */
	private String deliveryDate;
	/**
	 * 配送时段
	 */
	private int deliveryTimeSlot;
	
	private String deliveryTime;
	/**
	 * 优惠券id
	 */
	private Long couponId;
	
	/**
	 * 礼品卡
	 */
	private List<GiftCardVO> giftCards;

	/**
	 * 运费
	 */
	private PostageVO postage;
	
	/**
	 * 商场VIP
	 */
	private MarketVipDTO marketVip;

	/**
	 * 联系电话
	 */
	private String contactPhone;
	
	/**
	 * 联系人
	 */
	private String contactPerson;
	
	/**
	 * 招商银行APP支付
	 */
	private Boolean cmbAppPay = false;
	
	/**
	 * 订单业务类型
	 */
	private OrderBusinessType orderType = OrderBusinessType.NORMAL;

	public List<RequestPack> getPacks() {
		return packs;
	}

	public void setPacks(List<RequestPack> packs) {
		this.packs = packs;
	}

	public Boolean isUseBdayDiscount() {
		return useBdayDiscount;
	}

	public void setUseBdayDiscount(Boolean useBdayDiscount) {
		this.useBdayDiscount = useBdayDiscount;
	}

	public Boolean getUsePointDeduct() {
		return usePointDeduct;
	}

	public void setUsePointDeduct(Boolean usePointDeduct) {
		this.usePointDeduct = usePointDeduct;
	}

	public Boolean getUseAccountDeduct() {
		return useAccountDeduct;
	}

	public void setUseAccountDeduct(Boolean useAccountDeduct) {
		this.useAccountDeduct = useAccountDeduct;
	}

	public long getAddressId() {
		return addressId;
	}

	public void setAddressId(long addressId) {
		this.addressId = addressId;
	}

	public String getDeliveryDate() {
		return deliveryDate;
	}

	public void setDeliveryDate(String deliveryDate) {
		this.deliveryDate = deliveryDate;
	}

	public int getDeliveryTimeSlot() {
		return deliveryTimeSlot;
	}

	public void setDeliveryTimeSlot(int deliveryTimeSlot) {
		this.deliveryTimeSlot = deliveryTimeSlot;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public List<GiftCardVO> getGiftCards() {
		return giftCards;
	}

	public void setGiftCards(List<GiftCardVO> giftCards) {
		this.giftCards = giftCards;
	}

	public PostageVO getPostage() {
		return postage;
	}

	public void setPostage(PostageVO postage) {
		this.postage = postage;
	}

	public String getDeliveryTime() {
		return deliveryTime;
	}

	public void setDeliveryTime(String deliveryTime) {
		this.deliveryTime = deliveryTime;
	}

	public MarketVipDTO getMarketVip() {
		return marketVip;
	}

	public void setMarketVip(MarketVipDTO marketVip) {
		this.marketVip = marketVip;
	}

	public OrderBusinessType getOrderType() {
		return orderType;
	}

	public void setOrderType(OrderBusinessType orderType) {
		this.orderType = orderType;
	}

	public String getContactPhone() {
		return contactPhone;
	}

	public void setContactPhone(String contactPhone) {
		this.contactPhone = contactPhone;
	}

	public String getContactPerson() {
		return contactPerson;
	}

	public void setContactPerson(String contactPerson) {
		this.contactPerson = contactPerson;
	}

	public Boolean getCmbAppPay() {
		return cmbAppPay;
	}

	public void setCmbAppPay(Boolean cmbAppPay) {
		this.cmbAppPay = cmbAppPay;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
	}
	
}
