package com.thebeastshop.support.vo.campaign;

import com.google.common.collect.Lists;
import com.thebeastshop.support.vo.pack.GiftPackVO;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * @ClassName SectionProductVO
 * @Description: 阶梯商品
 * @Author: Xiang.Gao
 * @Create: 2019-12-30
 **/
public class SectionProductVO {

    /**
     * 商品Code
     */
    private String productId;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 是否多规格
     */
    private Boolean hasVariants = false;

    /**
     * 是否可编辑
     */
    private Boolean editable = false;

    /**
     * 是否来单
     */
    private Boolean isJit = false;

    /**
     * 每次赠送数量
     */
    private int each;

    /**
     * 按组显示
     */
    private Boolean groupShow = false;

    /**
     * 赠品包
     */
    private List<GiftPackVO> giftPacks = Lists.newArrayList();

    /**
     * 已赠完
     */
    private Boolean sellOut = false;

    /**
     * 排序
     */
    private Float sort;

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Boolean getHasVariants() {
        return hasVariants;
    }

    public void setHasVariants(Boolean hasVariants) {
        this.hasVariants = hasVariants;
    }

    public Boolean getEditable() {
        return editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public Boolean getJit() {
        return isJit;
    }

    public void setJit(Boolean jit) {
        isJit = jit;
    }

    public int getEach() {
        return each;
    }

    public void setEach(int each) {
        this.each = each;
    }

    public Boolean getGroupShow() {
        return groupShow;
    }

    public void setGroupShow(Boolean groupShow) {
        this.groupShow = groupShow;
    }

    public List<GiftPackVO> getGiftPacks() {
        return giftPacks;
    }

    public void setGiftPacks(List<GiftPackVO> giftPacks) {
        this.giftPacks = giftPacks;
    }

    public Boolean getSellOut() {
        return sellOut;
    }

    public void setSellOut(Boolean sellOut) {
        this.sellOut = sellOut;
    }

    public Float getSort() {
        return sort;
    }

    public void setSort(Float sort) {
        this.sort = sort;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
