package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;
import com.thebeastshop.support.mark.HasName;

/**
 * 商品包来源。包括用户自主购买的、赠品、加价购
 *
 * @author Liang Wenjian
 */
public enum CartPackSource implements HasIntIdGetter, HasName {

	/**
	 * 来自用户自购
	 */
	RAW(0, "自购"),
	/**
	 * 来自赠品
	 */
	GIFT(3, "买赠"),

	/**
	 * 加价购
	 */
	ADDIBLE(4,"加价格"),


	BENEFIT(5,"权益商品");

	public final Integer id;
	public final String name;

	private CartPackSource(Integer id, String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}
}
