package com.thebeastshop.support.vo.product;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 团购信息
 * 
 * @author WangYawei
 *
 */
public class Groupon implements Serializable {

	private static final long serialVersionUID = 1L;

	private String groupCode;// 团购活动code

	private String spellGroupCode;// 拼团编号

	private List<BigDecimal> price;// 团购价

	private int number;// 拼团人数

	private String type;// <GROWTH|ALL> 团购类型 老带新|全员

	private int remindStock;// 提醒库存数

	private String detailImage;// 团购后台配的图，若为null显示原商品的动态内容

	private String groupTitle;// 团购标题

	private String groupDesc;// 团购描述

	private int left;// 团购库存 多规格时用所有spv的库存和，如果有库存但不够开团，直接给0）

	private Integer remainSpellNum;// 用户对单商品剩余开团次数，该次数为总次数减去开团中以及开团成功的次数；如果没有值代表不限制次数

	private Boolean isStart = false;// 团购活动是否开始

	private Boolean isEnd;// 团购活动是否结束（指整个商品团购是否结束）默认未结束

	private Boolean isNew;// 是否是新用户

	private SpellGroup spellGroup;// 拼团信息

	private Rule rule; // 拼团规则

	private Share share; // 拼团规则

	public Share getShare() {
		return share;
	}

	public void setShare(Share share) {
		this.share = share;
	}

	public Boolean getIsNew() {
		return isNew;
	}

	public void setIsNew(Boolean isNew) {
		this.isNew = isNew;
	}

	public String getGroupCode() {
		return groupCode;
	}

	public void setGroupCode(String groupCode) {
		this.groupCode = groupCode;
	}

	public String getSpellGroupCode() {
		return spellGroupCode;
	}

	public void setSpellGroupCode(String spellGroupCode) {
		this.spellGroupCode = spellGroupCode;
	}

	public List<BigDecimal> getPrice() {
		return price;
	}

	public void setPrice(List<BigDecimal> price) {
		this.price = price;
	}

	public int getNumber() {
		return number;
	}

	public void setNumber(int number) {
		this.number = number;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public int getRemindStock() {
		return remindStock;
	}

	public void setRemindStock(int remindStock) {
		this.remindStock = remindStock;
	}

	public String getDetailImage() {
		return detailImage;
	}

	public void setDetailImage(String detailImage) {
		this.detailImage = detailImage;
	}

	public String getGroupTitle() {
		return groupTitle;
	}

	public void setGroupTitle(String groupTitle) {
		this.groupTitle = groupTitle;
	}

	public String getGroupDesc() {
		return groupDesc;
	}

	public void setGroupDesc(String groupDesc) {
		this.groupDesc = groupDesc;
	}

	public int getLeft() {
		return left;
	}

	public void setLeft(int left) {
		this.left = left;
	}

	public Integer getRemainSpellNum() {
		return remainSpellNum;
	}

	public void setRemainSpellNum(Integer remainSpellNum) {
		this.remainSpellNum = remainSpellNum;
	}

	public Boolean getIsStart() {
		return isStart;
	}

	public void setIsStart(Boolean isStart) {
		this.isStart = isStart;
	}

	public Boolean getIsEnd() {
		return isEnd;
	}

	public void setIsEnd(Boolean isEnd) {
		this.isEnd = isEnd;
	}

	public SpellGroup getSpellGroup() {
		return spellGroup;
	}

	public void setSpellGroup(SpellGroup spellGroup) {
		this.spellGroup = spellGroup;
	}

	public Rule getRule() {
		return rule;
	}

	public void setRule(Rule rule) {
		this.rule = rule;
	}

	@Override
	public String toString() {
		return "Groupon [groupCode =" + groupCode + ", spellGroupCode =" + spellGroupCode + ", price =" + price
				+ ", number =" + number + ", type =" + type + ", remindStock =" + remindStock + ", detailImage ="
				+ detailImage + ", groupTitle =" + groupTitle + ", groupDesc =" + groupDesc + ", left =" + left
				+ ", remainSpellNum =" + remainSpellNum + ", isStart =" + isStart + ", isEnd =" + isEnd
				+ ", spellGroup =" + spellGroup + ", rule =" + rule + ", isNew =" + isNew + ", share =" + share + "]";
	}
}