package com.thebeastshop.support.vo.cart;

import java.io.Serializable;
import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.customize.UserSingleCustomization;

/**
 * 购物车请求实例
 * Created by GFL on 2017/9/12.
 */
public class RequestPack implements Serializable {

    private static final long serialVersionUID = -6278797198649518199L;
    /**
     * 购物车id
     */
    private Long id;
    /**
     * 商品spvid
     */
    private Long spvId;
    /**
     * 商品数量
     */
    private int count = 1;
    
    /**
	 * 门店发货数量
	 */
	private int storeCount;
	
	/**
	 * 仓库发货数量
	 */
	private int warehouseCount;
    
    /**
     * 商品来源 @CartPackSource ，默认自购
     */
    private CartPackSource source = CartPackSource.RAW;
    /**
     * 定制项列表
     */
    private List<UserSingleCustomization> customizes;
    /**
     * 綁定值
     */
    private String bindValue;
    /**
     * 配送信息
     */
    private List<DeliveryVO> deliverys;
    /**
	 * 赠品商品
	 */
	private List<RequestPack> giftPacks;
    /**
     * 是否需要扎丝带
     */
	private Boolean needCorses = false;

    /**
     * 活动阶梯ID
     */
    private Integer campaignSectionId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

	public int getStoreCount() {
		return storeCount;
	}

	public void setStoreCount(int storeCount) {
		this.storeCount = storeCount;
	}

	public int getWarehouseCount() {
		return warehouseCount;
	}

	public void setWarehouseCount(int warehouseCount) {
		this.warehouseCount = warehouseCount;
	}

	public CartPackSource getSource() {
        return source;
    }

    public void setSource(CartPackSource source) {
        this.source = source;
    }

    public List<UserSingleCustomization> getCustomizes() {
        return customizes;
    }

    public void setCustomizes(List<UserSingleCustomization> customizes) {
        this.customizes = customizes;
    }

    public String getBindValue() {
        return bindValue;
    }

    public void setBindValue(String bindValue) {
        this.bindValue = bindValue;
    }

	public List<DeliveryVO> getDeliverys() {
		return deliverys;
	}

	public void setDeliverys(List<DeliveryVO> deliverys) {
		this.deliverys = deliverys;
	}

	public List<RequestPack> getGiftPacks() {
		return giftPacks;
	}

	public void setGiftPacks(List<RequestPack> giftPacks) {
		this.giftPacks = giftPacks;
	}

    public Boolean getNeedCorses() {
        return needCorses;
    }

    public void setNeedCorses(Boolean needCorses) {
        this.needCorses = needCorses;
    }

    public Integer getCampaignSectionId() {
        return campaignSectionId;
    }

    public void setCampaignSectionId(Integer campaignSectionId) {
        this.campaignSectionId = campaignSectionId;
    }

    @Override
    public String toString() {
    	return JSONObject.toJSONString(this);
    }
}
