package com.thebeastshop.support.exception;

/**
 * 实现本接口的异常类表示其与某个电商平台有关。（不一定是电商平台平台发生了错误，比如连接电商平台的api时发生的网络异常）
 *
 * @author Liang Wenjian
 */
public interface PlatProblem {
    /**
     * 发生错误的平台的名字。
     *
     * @return
     */
    String getPlatName();

    /**
     * 平台返回的错误代码。
     *
     * @return 可能为空。
     */
    String getPlatErrCode();

    /**
     * 平台返回的错误消息。
     *
     * @return 可能为空。
     */
    String getPlatErrMsg();

    /**
     * 一个工具类。
     */
    class PlatProblemUtil {
        public static final String PLAT_NAME_PLACEHOLDER = "{PLAT_NAME_PLACEHOLDER}";

        public static final String DEFAULT_PLAT_NAME = "电商";

        public static String replaceParams(final String msgTemplate, final PlatProblem platProblem) {
            return replaceParams(msgTemplate, platProblem.getPlatName(), platProblem.getPlatErrCode(),
                                 platProblem.getPlatErrMsg());
        }

        public static String replaceParams(final String msgTemplate, final String platName, final String platErrCode, final String platErrMsg) {
            return msgTemplate.replace(PLAT_NAME_PLACEHOLDER,
                                       platName == null || platName.trim().isEmpty() ? DEFAULT_PLAT_NAME : platName)//
                       + "（平台返回错误代码：" + (platErrCode == null ? "无" : platErrCode)//
                       + "，平台返回错误信息：" + (platErrMsg == null ? "无" : platErrMsg) + "）";
        }
    }
}
