package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.Type;

/**
 * 支付类型
 * 
 * @author Paul-xiong
 *
 */
public enum PaymentType implements Type {
    CUSTOMER_SERVICE(0, "客服"),
    CASH(1, "现金"),
    DEBIT_CARD(2, "借记卡"),
    CREDIT_CARD(3, "信用卡"),
    WEIXIN(4, "微信"),
    ALIPAY(5, "支付宝"),
    CMB(6, "招行"),
    TRANSFER(7, "转账"),
    YCK(8, "预存款"),
    YEZHU(9, "业主"),
    MARKET_COUPON(10, "商场优惠券"),
    QUICK_PASS(11, "银联云闪付")
    ;

    public final int id;
    public final String name;

    PaymentType(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }

}
