package com.thebeastshop.support.enums;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 活动状态
 * <DONE|ING|NOW|SOON> 已结束|已开抢|进行中|即将开始
 */
public enum CampaignState {
	/**
	 * 已结束
	 */
	DONE(1, "DONE"),

	/**
	 * 已开始
	 */
	ING(2, "ING"),

	/**
	 * 进行中
	 */
	NOW(3, "NOW"),

	/**
	 * 即将开始
	 */
	SOON(4, "SOON");

	private final int id;
	private final String name;

	CampaignState(final int id, final String name) {
		this.id = id;
		this.name = name;
	}

	public Integer getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this).append("id", id).append("name", name).toString();
	}
}
