package com.thebeastshop.support.vo.pack;

import com.thebeastshop.support.vo.product.SpvVO;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description: 赠品包
 * @author: Xiang.Gao
 * @create: 2019-12-19
 **/
public class GiftPackVO {

    /**
     * 赠品总数量
     */
    private int count;

    /**
     * 本店发货数量
     */
    private int storeCount;

    /**
     * 仓库发货数量
     */
    private int warehouseCount;

    /**
     * SPV
     */
    private SpvVO spv;

    /**
     * 赠品最大可选量
     */
    private int maximun;

    /**
     * 赠送组数
     */
    private int times;

    /**
     * 已赠完
     */
    private Boolean sellOut = false;

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getStoreCount() {
        return storeCount;
    }

    public void setStoreCount(int storeCount) {
        this.storeCount = storeCount;
    }

    public int getWarehouseCount() {
        return warehouseCount;
    }

    public void setWarehouseCount(int warehouseCount) {
        this.warehouseCount = warehouseCount;
    }

    public SpvVO getSpv() {
        return spv;
    }

    public void setSpv(SpvVO spv) {
        this.spv = spv;
    }

    public int getMaximun() {
        return maximun;
    }

    public void setMaximun(int maximun) {
        this.maximun = maximun;
    }

    public int getTimes() {
        return times;
    }

    public void setTimes(int times) {
        this.times = times;
    }

    public Boolean getSellOut() {
        return sellOut;
    }

    public void setSellOut(Boolean sellOut) {
        this.sellOut = sellOut;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
