package com.thebeastshop.support.vo.order;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.google.common.collect.Lists;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.vo.member.MemberAddressVO;

/**
 * 订单基础信息
 * 
 * @author Paul-xiong
 *
 */
public class OrderSimpleVO {
	/**
	 * 订单编号
	 */
	private String id;
	/**
	 * 订单状态
	 */
	private OrderStateVO state;
	/**
	 * 支付有效时间（计算得到秒数）
	 */
	private long payExpireTime = 0;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 价格
	 */
	private BigDecimal price;
	/**
	 * 商品包
	 */
	private Collection<OrderProductPackVO> packs = Lists.newArrayList();
	/**
	 * 地址信息
	 */
	private MemberAddressVO address;
	/**
	 * 是否包含海外购商品
	 */
	private boolean hasOverseaProducts = false;
	/**
	 * 可用的支付方式
	 */
	private List<PaymentType> payMethods;

	/**
	 * 订单类型：0普通，1月送鲜花
	 */
	private OrderBusinessType orderType= OrderBusinessType.NORMAL;
	
	public OrderBusinessType getOrderType() {
		return orderType;
	}

	public void setOrderType(OrderBusinessType orderType) {
		this.orderType = orderType;
	}
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public OrderStateVO getState() {
		return state;
	}

	public void setState(OrderStateVO state) {
		this.state = state;
	}

	public long getPayExpireTime() {
		return payExpireTime;
	}

	public void setPayExpireTime(long payExpireTime) {
		this.payExpireTime = payExpireTime;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public Collection<OrderProductPackVO> getPacks() {
		return packs;
	}

	public void setPacks(Collection<OrderProductPackVO> packs) {
		this.packs = packs;
	}

	public MemberAddressVO getAddress() {
		return address;
	}

	public void setAddress(MemberAddressVO address) {
		this.address = address;
	}

	public boolean isHasOverseaProducts() {
		return hasOverseaProducts;
	}

	public void setHasOverseaProducts(boolean hasOverseaProducts) {
		this.hasOverseaProducts = hasOverseaProducts;
	}

	@Override
	public String toString() {
		return "OrderSimpleVO [id=" + id + ", state=" + state + ", payExpireTime=" + payExpireTime + ", createTime="
				+ createTime + ", price=" + price + ", packs=" + packs + ", address=" + address
				+ ", hasOverseaProducts=" + hasOverseaProducts + ", payMethods=" + payMethods + "]";
	}

	public List<PaymentType> getPayMethods() {
		return payMethods;
	}

	public void setPayMethods(List<PaymentType> payMethods) {
		this.payMethods = payMethods;
	}

	/**
	 * 订单状态
	 * 
	 * @author Paul-xiong
	 *
	 */
	public static class OrderStateVO {
		/**
		 * 枚举id
		 */
		private int id;
		/**
		 * 枚举名
		 */
		private String type;
		/**
		 * 中文名
		 */
		private String name;
		/**
		 * 订单状态详细描述
		 */
		private String desc;

		public String getType() {
			return type;
		}

		public void setType(String type) {
			this.type = type;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getDesc() {
			return desc;
		}

		public void setDesc(String desc) {
			this.desc = desc;
		}

		public int getId() {
			return id;
		}

		public void setId(int id) {
			this.id = id;
		}

		@Override
		public String toString() {
			return "OrderStateVO [type=" + type + ", name=" + name + ", desc=" + desc + "]";
		}
	}

}
