package com.thebeastshop.support.enums;

import com.thebeastshop.support.mark.Type;

/**
 * 配置类型
 * 
 * @author wyw
 *
 */
public enum ConfigState implements Type {
	ONLINE(1, "线上"), DRAFT(0, "草稿"), OFFLINE(2, "往期"), PREPUB(3, "预约发布"), DELETE(4, "删除");
	private final int id;
	private final String name;

	ConfigState(final int id, final String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

}
