package com.thebeastshop.support.vo.exchange;

import com.google.common.collect.Lists;
import com.thebeastshop.support.enums.CampaignState;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by GFL on 2018/12/13.
 * 兑换秒杀
 */
public class ExchangeSecKill implements Serializable {

    private static final long serialVersionUID = -914420967380707988L;

    private String title;               // 标题

    private Date startTime;            // 开始时间

    private CampaignState state;        // 状态

    private List<ExchangeSimpleProductGoods> exchangeGoods= Lists.newArrayList();    // 兑换商品数组

    public ExchangeSecKill(String title, Date startTime, CampaignState state, List<ExchangeSimpleProductGoods> exchangeGoods) {
        this.title = title;
        this.startTime = startTime;
        this.state = state;
        this.exchangeGoods = exchangeGoods;
    }

    public ExchangeSecKill() {
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public CampaignState getState() {
        return state;
    }

    public void setState(CampaignState state) {
        this.state = state;
    }

    public List<ExchangeSimpleProductGoods> getExchangeGoods() {
        return exchangeGoods;
    }

    public void setExchangeGoods(List<ExchangeSimpleProductGoods> exchangeGoods) {
        this.exchangeGoods = exchangeGoods;
    }
}
