package com.thebeastshop.support.vo.customize;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 图片等值信息
 * Created by GFL on 2017/10/25.
 */
public class CustomImage implements Serializable {

    private static final long serialVersionUID = -4017019933157334229L;

    private Long  id;               // 定制图片id
    private String url;             // 定制图片url

    private List<CustomImagePosition> positions = new ArrayList<>();   // 图片定制区域

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<CustomImagePosition> getPositions() {
        return positions;
    }

    public void setPositions(List<CustomImagePosition> positions) {
        this.positions = positions;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("CustomImage{");
        sb.append("id=").append(id);
        sb.append(", url='").append(url).append('\'');
        sb.append(", positions=").append(positions);
        sb.append('}');
        return sb.toString();
    }
}
