package com.thebeastshop.support.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author Liang Wenjian
 */
public enum CouponOwnerStateEnum {
    UNABLE(0, "不可领取"),
    ABLE(1, "可领取"),
    ALABLE(2, "已领取"),
    ;

    final Integer id;
    final String name;

    public static final List<CouponOwnerStateEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));


    CouponOwnerStateEnum(final Integer id, final String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static CouponOwnerStateEnum getEnumById(Integer code) {
        for (CouponOwnerStateEnum e : CouponOwnerStateEnum.values()) {
            if (e.getId().equals(code)) {
                return e;
            }
        }
        return null;
    }
}
