/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.support.encode;

import java.security.SecureRandom;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

import com.thebeastshop.support.exception.WrongArgException;



/**
 * @author Eric.Lou
 * @version $Id: Encryption.java, v 0.1 2015-07-16 14:29
 */
public class DESUtil {

	// example
	// public static void main(String[] args) {
	// System.out.println(DESUtil.encrypt("11aacc"));
	// System.out.println(DESUtil.decrypt("64F2EC217FE2B082"));
	// }

	// 密钥
	private static final String PASSWORD_CRYPT_KEY = "pegasus;*100/100";

	private static final String DES = "DES";

	/**
	 * 加密
	 * 
	 * @param src
	 *            数据源
	 * @param key
	 *            密钥，长度必须是8的倍数
	 * @return 返回加密后的数据
	 * @throws Exception
	 */
	private static byte[] encrypt(byte[] src, byte[] key) throws Exception {

		// DES算法要求有一个可信任的随机数源
		SecureRandom sr = new SecureRandom();

		// 从原始密匙数据创建DESKeySpec对象
		DESKeySpec dks = new DESKeySpec(key);

		// 创建一个密匙工厂，然后用它把DESKeySpec转换成
		// 一个SecretKey对象
		SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
		SecretKey securekey = keyFactory.generateSecret(dks);

		// Cipher对象实际完成加密操作
		Cipher cipher = Cipher.getInstance(DES);

		// 用密匙初始化Cipher对象
		cipher.init(Cipher.ENCRYPT_MODE, securekey, sr);

		// 现在，获取数据并加密
		// 正式执行加密操作
		return cipher.doFinal(src);

	}

	/**
	 * 解密
	 * 
	 * @param src
	 *            数据源
	 * @param key
	 *            密钥，长度必须是8的倍数
	 * @return 返回解密后的原始数据
	 * @throws Exception
	 */
	private static byte[] decrypt(byte[] src, byte[] key) throws Exception {

		// DES算法要求有一个可信任的随机数源
		SecureRandom sr = new SecureRandom();

		// 从原始密匙数据创建一个DESKeySpec对象
		DESKeySpec dks = new DESKeySpec(key);

		// 创建一个密匙工厂，然后用它把DESKeySpec对象转换成
		// 一个SecretKey对象
		SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
		SecretKey securekey = keyFactory.generateSecret(dks);

		// Cipher对象实际完成解密操作
		Cipher cipher = Cipher.getInstance(DES);

		// 用密匙初始化Cipher对象
		cipher.init(Cipher.DECRYPT_MODE, securekey, sr);

		// 现在，获取数据并解密
		// 正式执行解密操作
		return cipher.doFinal(src);

	}

	/**
	 * 密码解密
	 * 
	 * @param data
	 * @return
	 * @throws Exception
	 */
	public final static String decrypt(String data) throws Exception {
		return decrypt(data, PASSWORD_CRYPT_KEY);
	}

	/**
	 * 密码解密
	 * 
	 * @param data
	 * @param key
	 * @return
	 * @throws Exception
	 */
	public final static String decrypt(String data, String key) throws Exception {
		if (data == null) {
			throw new WrongArgException("argument data is null ,do not decrypt");
		}
		byte bytes[] = Base64Util.decode(data);
		return new String(decrypt(bytes, key.getBytes()));

	}

	/**
	 * 密码加密
	 * 
	 * @param data
	 * @return
	 * @throws Exception
	 */
	public final static String encrypt(String data) throws Exception {
		return encrypt(data, PASSWORD_CRYPT_KEY);
	}

	/**
	 * 密码加密
	 * 
	 * @param data
	 * @param key
	 * @return
	 * @throws Exception
	 */
	public final static String encrypt(String data, String key) throws Exception {
		if (data == null) {
			throw new WrongArgException("argument data is null ,do not encrypt");
		}
		return Base64Util.encode((encrypt(data.getBytes(), key.getBytes())));
	}

}
