/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.page;

import com.thebeastshop.support.page.Sort;

public class Pagination {
    private static final int MAX_LIMIT = 1000;
    private Integer offset = 0;
    private Integer limit = 15;
    private Integer total = 0;
    private Sort sort = new Sort();

    public Pagination() {
    }

    public Pagination(Integer offset, Integer limit) {
        this.setOffset(offset);
        this.setLimit(limit);
    }

    public Pagination(Integer offset, Integer limit, Sort sort) {
        this(offset, limit);
        if (sort != null) {
            this.sort = sort;
        }
    }

    public Pagination(Pagination pagination) {
        if (pagination == null) {
            throw new NullPointerException("pagination is null");
        }
        this.offset = pagination.offset;
        this.limit = pagination.limit;
        this.total = pagination.total;
        if (pagination.getSortField() != null) {
            this.setSortField(pagination.getSortField());
        }
        if (pagination.getSortOrder() != null) {
            this.setSortOrder(pagination.getSortOrder());
        }
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        if (offset != null && offset >= 0) {
            this.offset = offset;
        }
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        if (limit != null && limit > 0) {
            if (limit > 1000) {
                limit = 1000;
            }
            this.limit = limit;
        }
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        if (total != null) {
            this.total = total;
        }
    }

    public String getSortField() {
        return this.sort.getSortField();
    }

    public void setSortField(String sortField) {
        this.sort.setSortField(sortField);
    }

    public String getSortOrder() {
        return this.sort.getSortOrder();
    }

    public void setSortOrder(String sortOrder) {
        this.sort.setSortOrder(sortOrder);
    }

    public int hashCode() {
        return this.sort.hashCode();
    }

    public boolean equals(Object obj) {
        return this.sort.equals(obj);
    }

    public String toString() {
        return "Pagination [offset=" + this.offset + ", limit=" + this.limit + ", total=" + this.total + ", sort=" + this.sort + "]";
    }
}

