package com.thebeastshop.support.vo.product;

import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.flowerMonth.FlowerMonthDistType;
import com.thebeastshop.support.vo.product.SpvVO.BrandVO;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 商品基础信息
 * 
 * @author Paul-xiong
 *
 */
public class SimpleProductVO {
	private Boolean isOversea = false;
	private String id;
	private String featureImage = "";
	private String specialImage = "";             //商品专项图片，用于特殊场景如：选礼商品图片 sinse 4.7.0
	private String specialDesc = "";              //商品专项描述，用于特殊场景如：选礼商品描述 sinse 4.7.0
	private List<String> images = new ArrayList<String>();
	private BrandVO brand;
	private String name;
	private String summary;
	private Boolean soldOut;
	private String stockWarn;	//库存预警
	private Boolean invisible;
	private Boolean offShelf;
	private List<Label> labels = new ArrayList<Label>();
	private BigDecimal price;
	private BigDecimal rawPrice;
	private BigDecimal pointPrice;  // 积分抵扣后价格
	private Integer point; // 兑换积分数
	private List<String> waterMarkImage;
	private DiscVO discount;
	private PriceForecastVO priceForecast;
	private Boolean rush;
	private Boolean monthSend = false;
	private FlowerMonthDistType monthSendDistType = FlowerMonthDistType.EXPRESS; // 月送配送类型
	private String activityDesc;
	private Boolean vipOnly = false;// VIP专享商品
	private Boolean foretell = false;// 预告商品
	private Boolean hasPresale = false; // 是否预售
	private Boolean customizable = false; // 商品是否可定制
	private String unSaleDesc; // 不可售描述
	private Boolean combined = false; // 是否组合商品
	private Boolean combination = false; // 组合搭配商品
	private Boolean pointDeduction= false; // 积分抵扣标识
	private List<ProductCampaignVO> campaigns;// 商品参与活动信息列表
	private BigPicVO bigPic; // 是否是大图
	private Boolean hasJit = false; // 是否来单
	private Boolean newcomerTag = false; // 新人价标签
	private Boolean birthdayGift = false; // 是否生日礼
	private Boolean onLineOnly = false; // 线上专享商品
	private Boolean allowCampaign = true; // 是否参与活动优惠券
	private BigDecimal commissionRate; // 佣金比列
	private BigDecimal commissionAmount; // 佣金金额
	private VideoVO video;

	public BigPicVO getBigPic() {
		return bigPic;
	}

	public void setBigPic(BigPicVO bigPic) {
		this.bigPic = bigPic;
	}

	public Boolean getForetell() {
		return foretell;
	}

	public void setForetell(Boolean foretell) {
		this.foretell = foretell;
	}

	public String getActivityDesc() {
		return activityDesc;
	}

	public void setActivityDesc(String activityDesc) {
		this.activityDesc = activityDesc;
	}

	public Boolean getIsOversea() {
		return isOversea;
	}

	public void setIsOversea(Boolean isOversea) {
		this.isOversea = isOversea;
	}

	public Boolean getCustomizable() {
		return customizable;
	}

	public void setCustomizable(Boolean customizable) {
		this.customizable = customizable;
	}

	public Boolean getRush() {
		return rush;
	}

	public void setRush(Boolean rush) {
		this.rush = rush;
	}

	public PriceForecastVO getPriceForecast() {
		return priceForecast;
	}

	public void setPriceForecast(PriceForecastVO priceForecast) {
		this.priceForecast = priceForecast;
	}

	public DiscVO getDiscount() {
		return discount;
	}

	public void setDiscount(DiscVO discount) {
		this.discount = discount;
	}

	public SimpleProductVO() {
		super();
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getFeatureImage() {
		return featureImage;
	}

	public void setFeatureImage(String featureImage) {
		this.featureImage = featureImage;
	}

	public List<String> getImages() {
		return images;
	}

	public void setImages(List<String> images) {
		this.images = images;
	}

	public String getSpecialImage() {
		return specialImage;
	}

	public void setSpecialImage(String specialImage) {
		this.specialImage = specialImage;
	}

	public String getSpecialDesc() {
		return specialDesc;
	}

	public void setSpecialDesc(String specialDesc) {
		this.specialDesc = specialDesc;
	}

	public BrandVO getBrand() {
		return brand;
	}

	public void setBrand(BrandVO brand) {
		this.brand = brand;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public BigDecimal getRawPrice() {
		return rawPrice;
	}

	public void setRawPrice(BigDecimal rawPrice) {
		this.rawPrice = rawPrice;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public Integer getPoint() {
		return point;
	}

	public void setPoint(Integer point) {
		this.point = point;
	}

	public Boolean getSoldOut() {
		return soldOut;
	}

	public void setSoldOut(Boolean soldOut) {
		this.soldOut = soldOut;
	}

	public String getStockWarn() {
		return stockWarn;
	}

	public void setStockWarn(String stockWarn) {
		this.stockWarn = stockWarn;
	}

	public Boolean getInvisible() {
		return invisible;
	}

	public void setInvisible(Boolean invisible) {
		this.invisible = invisible;
	}

	public Boolean getOffShelf() {
		return offShelf;
	}

	public void setOffShelf(Boolean offShelf) {
		this.offShelf = offShelf;
	}

	public List<Label> getLabels() {
		return labels;
	}

	public void setLabels(List<Label> labels) {
		this.labels = labels;
	}

	public List<String> getWaterMarkImage() {
		return waterMarkImage;
	}

	public void setWaterMarkImage(List<String> waterMarkImage) {
		this.waterMarkImage = waterMarkImage;
	}

	public Boolean getMonthSend() {
		return monthSend;
	}

	public void setMonthSend(Boolean monthSend) {
		this.monthSend = monthSend;
	}

	public FlowerMonthDistType getMonthSendDistType() {
		return monthSendDistType;
	}

	public void setMonthSendDistType(FlowerMonthDistType monthSendDistType) {
		this.monthSendDistType = monthSendDistType;
	}

	public Boolean getVipOnly() {
		return vipOnly;
	}

	public void setVipOnly(Boolean vipOnly) {
		this.vipOnly = vipOnly;
	}

	public Boolean getHasPresale() {
		return hasPresale;
	}

	public void setHasPresale(Boolean hasPresale) {
		this.hasPresale = hasPresale;
	}

	public String getUnSaleDesc() {
		return unSaleDesc;
	}

	public void setUnSaleDesc(String unSaleDesc) {
		this.unSaleDesc = unSaleDesc;
	}

	public Boolean getCombined() {
		return combined;
	}

	public void setCombined(Boolean combined) {
		this.combined = combined;
	}

	public boolean getCombination() {
		return combination;
	}

	public void setCombination(boolean combination) {
		this.combination = combination;
	}

	public List<ProductCampaignVO> getCampaigns() {
		return campaigns;
	}

	public void setCampaigns(List<ProductCampaignVO> campaigns) {
		this.campaigns = campaigns;
	}

	public Boolean getHasJit() {
		return hasJit;
	}

	public void setHasJit(Boolean hasJit) {
		this.hasJit = hasJit;
	}

	public BigDecimal getPointPrice() {
		return pointPrice;
	}

	public void setPointPrice(BigDecimal pointPrice) {
		this.pointPrice = pointPrice;
	}

	public Boolean getPointDeduction() {
		return pointDeduction;
	}

	public void setPointDeduction(Boolean pointDeduction) {
		this.pointDeduction = pointDeduction;
	}
	
	public Boolean getNewcomerTag() {
		return newcomerTag;
	}

	public void setNewcomerTag(Boolean newcomerTag) {
		this.newcomerTag = newcomerTag;
	}
	
	public Boolean getBirthdayGift() {
		return birthdayGift;
	}

	public void setBirthdayGift(Boolean birthdayGift) {
		this.birthdayGift = birthdayGift;
	}

	public Boolean getOnLineOnly() {
		return onLineOnly;
	}

	public void setOnLineOnly(Boolean onLineOnly) {
		this.onLineOnly = onLineOnly;
	}

	public Boolean getAllowCampaign() {
		return allowCampaign;
	}

	public void setAllowCampaign(Boolean allowCampaign) {
		this.allowCampaign = allowCampaign;
	}

	public BigDecimal getCommissionRate() {
		return commissionRate;
	}

	public void setCommissionRate(BigDecimal commissionRate) {
		this.commissionRate = commissionRate;
	}

	public BigDecimal getCommissionAmount() {
		return commissionAmount;
	}

	public void setCommissionAmount(BigDecimal commissionAmount) {
		this.commissionAmount = commissionAmount;
	}

	public VideoVO getVideo() {
		return video;
	}

	public void setVideo(VideoVO video) {
		this.video = video;
	}

	@Override
	public String toString() {
		return "SimpleProductVO{" +
				"isOversea=" + isOversea +
				", id='" + id + '\'' +
				", featureImage='" + featureImage + '\'' +
				", specialImage='" + specialImage + '\'' +
				", specialDesc='" + specialDesc + '\'' +
				", images=" + images +
				", brand=" + brand +
				", name='" + name + '\'' +
				", summary='" + summary + '\'' +
				", soldOut=" + soldOut +
				", stockWarn='" + stockWarn + '\'' +
				", invisible=" + invisible +
				", offShelf=" + offShelf +
				", labels=" + labels +
				", price=" + price +
				", rawPrice=" + rawPrice +
				", pointPrice=" + pointPrice +
				", point=" + point +
				", waterMarkImage=" + waterMarkImage +
				", discount=" + discount +
				", priceForecast=" + priceForecast +
				", rush=" + rush +
				", monthSend=" + monthSend +
				", monthSendDistType=" + monthSendDistType +
				", activityDesc='" + activityDesc + '\'' +
				", vipOnly=" + vipOnly +
				", foretell=" + foretell +
				", hasPresale=" + hasPresale +
				", customizable=" + customizable +
				", unSaleDesc='" + unSaleDesc + '\'' +
				", combined=" + combined +
				", combination=" + combination +
				", pointDeduction=" + pointDeduction +
				", campaigns=" + campaigns +
				", bigPic=" + bigPic +
				", hasJit=" + hasJit +
				", newcomerTag=" + newcomerTag +
				", birthdayGift=" + birthdayGift +
				", onLineOnly=" + onLineOnly +
				", allowCampaign=" + allowCampaign +
				", commissionRate=" + commissionRate +
				", commissionAmount=" + commissionAmount +
				'}';
	}

	/**
	 * 折扣标签
	 * 
	 * @author Yawei-wang
	 *
	 */
	public static class DiscVO implements Serializable {

		/**
		 * 是否为 vip 折扣，若为抢购价，则为 false
		 */
		private String vipLevel;

		/**
		 * App 专享价格
		 */
		private boolean appOnly;

		/**
		 * 是否为生日折扣
		 */
		private Boolean birthday;

		public Boolean isBirthday() {
			return birthday;
		}

		public void setBirthday(Boolean birthday) {
			this.birthday = birthday;
		}

		public String getVipLevel() {
			return vipLevel;
		}

		public void setVipLevel(String vipLevel) {
			this.vipLevel = vipLevel;
		}

		public boolean isAppOnly() {
			return appOnly;
		}

		public void setAppOnly(boolean appOnly) {
			this.appOnly = appOnly;
		}

		@Override
		public String toString() {
			return "DiscVO{" +
					"vipLevel='" + vipLevel + '\'' +
					", appOnly=" + appOnly +
					", birthday=" + birthday +
					'}';
		}
	}

	/**
	 * 预售价
	 * 
	 * @author Yawei-wang
	 *
	 */
	public static class PriceForecastVO implements Serializable {

		/**
		 * 开始时间
		 */
		private Timestamp since;
		/**
		 * 预告价名称：如 "圣诞狂欢季"
		 */
		private String name;
		/**
		 * 价格范围，若只有一种价格，则包含两个相同价格。
		 */
		private Collection<BigDecimal> range = new ArrayList<BigDecimal>();

		public Timestamp getSince() {
			return since;
		}

		public void setSince(Timestamp since) {
			this.since = since;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public Collection<BigDecimal> getRange() {
			return range;
		}

		public void setRange(Collection<BigDecimal> range) {
			this.range = range;
		}

		@Override
		public String toString() {
			return "PriceForecastVO [since =" + since + ", name =" + name + ", range =" + range + "]";
		}

	}

	/**
	 * 预售价
	 * 
	 * @author Yawei-wang
	 *
	 */
	public static class BigPicVO implements Serializable {

		// 是否大图
		private Boolean isBigPic;

		// 大图link
		private String src;

		public Boolean getIsBigPic() {
			return isBigPic;
		}

		public void setIsBigPic(Boolean isBigPic) {
			this.isBigPic = isBigPic;
		}

		public String getSrc() {
			return src;
		}

		public void setSrc(String src) {
			this.src = src;
		}

		@Override
		public String toString() {
			return "BigPicVO [isBigPic =" + isBigPic + ", src =" + src + "]";
		}
	}

}
