package com.thebeastshop.support.vo.product;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 定金相关
 * 
 * @author wyw
 *
 */
public class DownPaymentVO implements Serializable {

	/**
	 * 是否展示
	 */
	private Boolean show = Boolean.FALSE;

	/**
	 * 能否购买定金
	 */
	private Boolean canBuy = Boolean.FALSE;

	/**
	 * 定金截止时间
	 */
	private String downTimeStr;

	/**
	 * 尾款截止时间
	 */
	private String finalTimeStr;

	private List<DownSpvVO> details;// 团购信息

	private List<BigDecimal> range;// 定价区间

	private DownDiscountVO discount;

	public Boolean getShow() {
		return show;
	}

	public void setShow(Boolean show) {
		this.show = show;
	}

	public Boolean getCanBuy() {
		return canBuy;
	}

	public void setCanBuy(Boolean canBuy) {
		this.canBuy = canBuy;
	}

	public String getDownTimeStr() {
		return downTimeStr;
	}

	public void setDownTimeStr(String downTimeStr) {
		this.downTimeStr = downTimeStr;
	}

	public String getFinalTimeStr() {
		return finalTimeStr;
	}

	public void setFinalTimeStr(String finalTimeStr) {
		this.finalTimeStr = finalTimeStr;
	}

	public List<DownSpvVO> getDetails() {
		return details;
	}

	public void setDetails(List<DownSpvVO> details) {
		this.details = details;
	}

	public List<BigDecimal> getRange() {
		return range;
	}

	public void setRange(List<BigDecimal> range) {
		this.range = range;
	}

	public DownDiscountVO getDiscount() {
		return discount;
	}

	public void setDiscount(DownDiscountVO discount) {
		this.discount = discount;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder("DownPaymentVO{");
		sb.append("show=").append(show);
		sb.append(", canBuy=").append(canBuy);
		sb.append(", downTimeStr='").append(downTimeStr).append('\'');
		sb.append(", finalTimeStr='").append(finalTimeStr).append('\'');
		sb.append(", details=").append(details);
		sb.append(", range=").append(range);
		sb.append(", discount=").append(discount);
		sb.append('}');
		return sb.toString();
	}
}
