package com.thebeastshop.support.vo.logistics;

import java.io.Serializable;
import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 邮费信息
 * 
 * @author Paul-xiong
 *
 */
public class PostageVO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 普通运费
	 */
	private BigDecimal normal;
	/**
	 * 偏远地区配送运费
	 */
	private BigDecimal faraway;
	/**
	 * 指定时段配送费用
	 */
	@JsonProperty("EDT")
	private BigDecimal EDT;

	public BigDecimal getNormal() {
		return normal;
	}

	public void setNormal(BigDecimal normal) {
		this.normal = normal;
	}

	public BigDecimal getFaraway() {
		return faraway;
	}

	public void setFaraway(BigDecimal faraway) {
		this.faraway = faraway;
	}

	@JsonIgnore
	public BigDecimal getEDT() {
		return EDT;
	}

	public void setEDT(BigDecimal eDT) {
		EDT = eDT;
	}

	@Override
	public String toString() {
		return "PostageVO [normal=" + normal + ", faraway=" + faraway + ", EDT=" + EDT + "]";
	}
}
