package com.thebeastshop.support.vo.logistics;

import java.util.List;

import com.thebeastshop.support.enums.LogisticsType;

/**
 * 物流信息Vo
 * 
 * @author Paul-xiong
 *
 */
public class LogisticsDetailVO {
	private LogisticsBasicVO raw = new LogisticsBasicVO();

	private List<LogisticsDesc> items;

	public LogisticsDetailVO() {
		super();
	}

	public LogisticsDetailVO(LogisticsBasicVO raw, List<LogisticsDesc> items) {
		super();
		this.raw = raw;
		this.items = items;
	}

	public LogisticsDetailVO(LogisticsBasicVO raw) {
		super();
		this.raw = raw;
	}

	public String getId() {
		return raw.getId();
	}

	public void setId(String id) {
		raw.setId(id);
	}

	public LogisticsType getType() {
		return raw.getType();
	}

	public void setType(LogisticsType type) {
		raw.setType(type);
	}

	public String getCompanyName() {
		return raw.getCompanyName();
	}

	public void setCompanyName(String companyName) {
		raw.setCompanyName(companyName);
	}

	public String getCompanyPhone() {
		return raw.getCompanyPhone();
	}

	public void setCompanyPhone(String companyPhone) {
		raw.setCompanyPhone(companyPhone);
	}

	public List<LogisticsDesc> getItems() {
		return items;
	}

	public void setItems(List<LogisticsDesc> items) {
		this.items = items;
	}

	/**
	 * 物流描述信息
	 * 
	 * @author Paul-xiong
	 *
	 */
	public static class LogisticsDesc {
		/**
		 * 物流信息描述
		 */
		private String desc;

		/**
		 * 日期
		 */
		private String dateTime;

		public LogisticsDesc() {
			super();
		}

		public LogisticsDesc(String desc, String dateTime) {
			super();
			this.desc = desc;
			this.dateTime = dateTime;
		}

		public String getDesc() {
			return desc;
		}

		public void setDesc(String desc) {
			this.desc = desc;
		}

		public String getDateTime() {
			return dateTime;
		}

		public void setDateTime(String dateTime) {
			this.dateTime = dateTime;
		}

		@Override
		public String toString() {
			return "LogisticsDesc [desc=" + desc + ", dateTime=" + dateTime + "]";
		}

	}
}
