package com.thebeastshop.support.vo.lesson;

import com.thebeastshop.support.enums.lesson.CourseTimeStatus;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 课程场次
 * Created by GFL on 2019/3/4.
 */
public class CourseTime implements Serializable {
    private static final long serialVersionUID = -8101702798009045143L;

    private String code;
    private String name;
    private CourseTimeStatus status;
    private String openTime;
    private String registerTime;
    private String cityName;
    private String address;
    private Long spvId;
    private String skuCode;
    private CoursePrice price;
    private CourseStock stock;
    private Integer openSill;     // 开课门槛
    private CourseQuota quota;     // 购买限额


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CourseTimeStatus getStatus() {
        return status;
    }

    public void setStatus(CourseTimeStatus status) {
        this.status = status;
    }

    public String getOpenTime() {
        return openTime;
    }

    public void setOpenTime(String openTime) {
        this.openTime = openTime;
    }

    public String getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(String registerTime) {
        this.registerTime = registerTime;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public CoursePrice getPrice() {
        return price;
    }

    public void setPrice(CoursePrice price) {
        this.price = price;
    }

    public CourseStock getStock() {
        return stock;
    }

    public void setStock(CourseStock stock) {
        this.stock = stock;
    }

    public Integer getOpenSill() {
        return openSill;
    }

    public void setOpenSill(Integer openSill) {
        this.openSill = openSill;
    }

    public CourseQuota getQuota() {
        return quota;
    }

    public void setQuota(CourseQuota quota) {
        this.quota = quota;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("code", code)
                .append("name", name)
                .append("status", status)
                .append("openTime", openTime)
                .append("registerTime", registerTime)
                .append("cityName", cityName)
                .append("address", address)
                .append("spvId", spvId)
                .append("skuCode", skuCode)
                .append("price", price)
                .append("stock", stock)
                .append("openSill", openSill)
                .append("quota", quota)
                .toString();
    }
}
