package com.thebeastshop.support.vo.flowerMonth;

import com.thebeastshop.support.vo.product.ProductVariantVO;

import java.io.Serializable;
import java.util.List;

/**
 * 月送鲜花规格
 * @author GFL
 * @Date 2018/1/30 16:00.
 */
public class FlowerMonthVariantVO implements Serializable {

    private static final long serialVersionUID = -3516304644670643136L;
    private ProductVariantVO variant;               //商品规格
    private List<FlowerMonthDistAreaVO> distAreas;    //配送地区
    private List<TiedDimensionVO> dimensions;         // 捆绑选项元素

    public ProductVariantVO getVariant() {
        return variant;
    }

    public void setVariant(ProductVariantVO variant) {
        this.variant = variant;
    }

    public List<FlowerMonthDistAreaVO> getDistAreas() {
        return distAreas;
    }

    public void setDistAreas(List<FlowerMonthDistAreaVO> distAreas) {
        this.distAreas = distAreas;
    }

    public List<TiedDimensionVO> getDimensions() {
        return dimensions;
    }

    public void setDimensions(List<TiedDimensionVO> dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("FlowerMonthVariant{");
        sb.append("variant=").append(variant);
        sb.append(", distAreas=").append(distAreas);
        sb.append(", dimensions=").append(dimensions);
        sb.append('}');
        return sb.toString();
    }
}
