package com.thebeastshop.support.vo.customize;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 定制属性选择类型
 * Created by feilong.gao on 2016/12/12.
 */
public class CustomChoice implements Serializable {
    /**
     * 选项名字
     */
    private String name;

    /**
     * 选项值
     */
    private String value;

    /**
     * 选项值
     */
    private String value2;

    /**
     * 是否可选
     */
    private Boolean available;

    /**
     * 关联属性
     */
    private RelevantColors relevant;

    public CustomChoice() {
    }

    public CustomChoice(String name, String value) {
        this.name = name;
        this.value = value;
        this.available = true;
    }

    public CustomChoice(String name, String value, String value2) {
        this.name = name;
        this.value = value;
        this.value2 = value2;
        this.available = true;
    }

    public CustomChoice(String name, String value, RelevantColors relevant) {
        this.name = name;
        this.value = value;
        this.available = true;
        this.relevant = relevant;
    }

    public CustomChoice(String name, String value, Boolean available) {
        this.name = name;
        this.value = value;
        this.available = available;
    }

    public CustomChoice(String name, String value, Boolean available, RelevantColors relevant) {
        this.name = name;
        this.value = value;
        this.available = available;
        this.relevant = relevant;
    }

    public CustomChoice(String name, String value, String value2, Boolean available, RelevantColors relevant) {
        this.name = name;
        this.value = value;
        this.value = value2;
        this.available = available;
        this.relevant = relevant;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue2() {
        return value2;
    }

    public void setValue2(String value2) {
        this.value2 = value2;
    }

    public Boolean getAvailable() {
        return available;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public RelevantColors getRelevant() {
        return relevant;
    }

    public void setRelevant(RelevantColors relevant) {
        this.relevant = relevant;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("name", name)
                .append("value", value)
                .append("value2", value2)
                .append("available", available)
                .append("relevant", relevant)
                .toString();
    }
}
