package com.thebeastshop.support.enums;

/**
 * 周枚举
 * Created by feilong.gao on 2016/12/6.
 */
public enum WeekEnum {

    SUNDAY(1,"周日"),
    MONDAY(2,"周一"),
    TUESDAY(3,"周二"),
    WEDNESDAY(4,"周三"),
    THURSDAY(5,"周四"),
    FRIDAY(6,"周五"),
    SATURDAY(7,"周六");

    private Integer code;
    private String desc;

    private WeekEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 获取奖品类型Code
     * @return
     */
    public Integer getCode() {
        return code;
    }

    /**
     * 获取奖品类型描述
     * @return
     */
    public String getDesc() {
        return desc;
    }

    /**
     * 根据Code获取描述
     * @param code
     * @return
     */
    public static String getDesc(Integer code){
        for(WeekEnum value : WeekEnum.values()){
            if(value.getCode().equals(code)){
                return value.getDesc();
            }
        }
        return "";
    }
}
