package com.thebeastshop.support.enums;

/**
 * 抽奖类型
 * Created by feilong.gao on 2016/12/6.
 */
public enum LotteryType {
    PRIZE_TYPE_COUPON("COUPON","优惠券"),
    PRIZE_TYPE_COUPON_THIRD("COUPON_THIRD","第三券"),
    PRIZE_TYPE_POINT("POINT","积分"),
    PRIZE_TYPE_PRODUCT("PRODUCT","商品"),
    PRIZE_TYPE_FREE_SHIPPING("FREE_SHIPPING","免邮权益");

    private String code;
    private String desc;

    private LotteryType(String code,String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 获取奖品类型Code
     * @return
     */
    public String getCode() {
        return code;
    }

    /**
     * 获取奖品类型描述
     * @return
     */
    public String getDesc() {
        return desc;
    }

    /**
     * 根据Code获取描述
     * @param code
     * @return
     */
    public static String getDesc(String code){
        for(LotteryType value :LotteryType.values()){
            if(value.getCode().equalsIgnoreCase(code)){
                return value.getDesc();
            }
        }
        return "";
    }
}
