package com.thebeastshop.support.encode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * 
 * @author Paul-xiong
 *
 */
public class Sha1Util {

	public static String sha1ToHexString(Map<String, Object> params) {
		StringBuilder data = new StringBuilder();
		List<String> keys = new ArrayList<String>(params.keySet());
		Collections.sort(keys);
		int index = 0;
		for (int i = 0; i < keys.size(); i++) {
			String key = keys.get(i);
			Object value = params.get(key);
			if (StringUtils.isNotBlank(key) && value != null && StringUtils.isNotBlank(value.toString())) {
				data.append((index == 0 ? "" : "&") + key + "=" + value);
				index++;
			}
		}
		return DigestUtils.sha1Hex(data.toString());
	}

	public static String sha1ToHexString(String data) {
		String rt = DigestUtils.sha1Hex(data);
		return rt;
	}
}
