/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.util.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thebeastshop.support.exception.SerializationException;
import com.thebeastshop.support.util.json.jackson.MapperConfigurator;
import com.thebeastshop.support.util.json.jackson.TypeConstructor;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public final class Jacksons {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final Jacksons DEFAULT = new Jacksons(null);
    private final MapperConfigurator mapperConfigurator;

    private Jacksons(MapperConfigurator mapperConfigurator) {
        this.mapperConfigurator = mapperConfigurator;
    }

    public static Jacksons defaultJacksons() {
        return DEFAULT;
    }

    public static Jacksons create(MapperConfigurator mapperConfigurator) {
        return new Jacksons(mapperConfigurator);
    }

    private static ObjectMapper newMapper() {
        ObjectMapper mapper = new ObjectMapper(JSON_FACTORY);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.getTypeFactory().constructArrayType(List.class);
        return mapper;
    }

    private ObjectMapper getMapper() {
        ObjectMapper mapper = Jacksons.newMapper();
        if (this.mapperConfigurator != null) {
            this.mapperConfigurator.configureMapper(mapper);
        }
        return mapper;
    }

    public <T> T toObject(String jsonString, Class<?> parametrized, Class<?> ... parameterClasses) {
        ObjectMapper mapper = this.getMapper();
        try {
            JavaType javaType = mapper.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
            return (T)mapper.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            throw new SerializationException(e, "jsonString", (Object)jsonString);
        }
    }

    public <T> T toObject(String jsonString, Type type) {
        ObjectMapper mapper = this.getMapper();
        try {
            JavaType javaType = mapper.getTypeFactory().constructType(type);
            return (T)mapper.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            throw new SerializationException(e, "jsonString", (Object)jsonString);
        }
    }

    public <T> T toObject(String jsonString, TypeConstructor typeConstructor) {
        ObjectMapper mapper = this.getMapper();
        try {
            return (T)mapper.readValue(jsonString, typeConstructor.constructType(mapper));
        }
        catch (IOException e) {
            throw new SerializationException(e, "jsonString", (Object)jsonString);
        }
    }

    public <T> T toObject(byte[] jsonBytes, Class<?> parametrized, Class<?> ... parameterClasses) {
        ObjectMapper mapper = this.getMapper();
        try {
            JavaType javaType = mapper.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
            return (T)mapper.readValue(jsonBytes, javaType);
        }
        catch (IOException e) {
            throw new SerializationException(e, "jsonBytes", (Object)jsonBytes);
        }
    }

    public <T> T toObject(byte[] jsonBytes, TypeConstructor typeConstructor) {
        ObjectMapper mapper = this.getMapper();
        try {
            return (T)mapper.readValue(jsonBytes, typeConstructor.constructType(mapper));
        }
        catch (IOException e) {
            throw new SerializationException(e, "jsonBytes", (Object)jsonBytes);
        }
    }

    public <K, V> List<Map<K, V>> toMaps(String jsonString) {
        return (List)this.toObject(jsonString, List.class, Map.class);
    }

    public <K, V> List<Map<K, V>> toMaps(byte[] jsonBytes) {
        return (List)this.toObject(jsonBytes, List.class, Map.class);
    }

    public <K, V> Map<K, V> toMap(Object object) {
        ObjectMapper mapper = this.getMapper();
        try {
            return (Map)mapper.convertValue(object, Map.class);
        }
        catch (Exception e) {
            throw new SerializationException(e, "object", object);
        }
    }

    public <K, V> Map<K, V> toMap(String jsonString) {
        return (Map)this.toObject(jsonString, Map.class, String.class, Object.class);
    }

    public <K, V> Map<K, V> toMap(byte[] jsonBytes) {
        return (Map)this.toObject(jsonBytes, Map.class, String.class, Object.class);
    }

    public <T> List<T> toBeans(String jsonString, Class<T> clazz) {
        return (List)this.toObject(jsonString, List.class, clazz);
    }

    public <T> List<T> toBeans(byte[] jsonBytes, Class<T> clazz) {
        return (List)this.toObject(jsonBytes, List.class, clazz);
    }

    public <T> T toBean(String jsonStr, Class<T> clazz) {
        return this.toObject(jsonStr, clazz);
    }

    public <T> T toBean(byte[] jsonBytes, Class<T> clazz) {
        return this.toObject(jsonBytes, clazz, new Class[0]);
    }

    public String toString(Object object) {
        ObjectMapper mapper = this.getMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new SerializationException(e, "object", object);
        }
    }

    public String toString(JsonNode jsonNode) {
        ObjectMapper mapper = this.getMapper();
        try {
            return mapper.writeValueAsString((Object)jsonNode);
        }
        catch (IOException e) {
            throw new SerializationException(e, "jsonNode", (Object)jsonNode);
        }
    }

    public byte[] toBytes(Object object) {
        ObjectMapper mapper = this.getMapper();
        try {
            return mapper.writeValueAsBytes(object);
        }
        catch (IOException e) {
            throw new SerializationException(e, "object", object);
        }
    }

    public byte[] toBytes(JsonNode jsonNode) {
        return this.toString(jsonNode).getBytes(Charset.forName("UTF-8"));
    }

    public JsonNode toJsonNode(Object object) {
        ObjectMapper mapper = this.getMapper();
        try {
            byte[] jsonBytes = mapper.writeValueAsBytes(object);
            return mapper.readTree(jsonBytes);
        }
        catch (IOException e) {
            throw new SerializationException(e, "object", object);
        }
    }

    public JsonNode toJsonNode(byte[] jsonBytes) {
        ObjectMapper mapper = this.getMapper();
        try {
            return mapper.readTree(jsonBytes);
        }
        catch (IOException e) {
            throw new SerializationException(e, "jsonBytes", (Object)jsonBytes);
        }
    }

    public JsonNode toJsonNode(String jsonString) {
        ObjectMapper mapper = this.getMapper();
        try {
            return mapper.readTree(jsonString);
        }
        catch (IOException e) {
            throw new SerializationException(e, "jsonString", (Object)jsonString);
        }
    }
}

