package com.thebeastshop.support.enums;

/**
 * 完善积分状态枚举
 * Created by feilong.gao on 2017/1/3.
 */
public enum PerfectPointState {

    PRE("PEE", "未达成"),
    VALID("VALID", "目前有效"),
    USED("USED", "已失效"),
    NONE("NONE", "无"),;

    private String code;
    private String desc;

    private PerfectPointState(String level, String name) {
        this.code = level;
        this.desc = name;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 获取完善信息积分状态
     *
     * @return
     */
    public static PerfectPointState getStateByCode(String code) {
        for (PerfectPointState value : PerfectPointState.values()) {
            if (value.getCode() == code) {
                return value;
            }
        }
        return null;
    }

}
