package com.thebeastshop.support.enums.Customize;

import com.thebeastshop.support.mark.HasIdGetter;
import com.thebeastshop.support.mark.HasName;

/**
 * 定制元素模式
 *
 * Created by feilong.gao on 2017/3/8.
 */
public enum  CustomizeMode implements HasIdGetter.HasIntIdGetter, HasName {

    BODY(1,"皮肤色"),
    TEXT_COLOR(2,"锈字色"),
    TEXT_INPUT(3,"锈字内容"),
    NORMAL(4,"普通");


    private Integer id;

    private String name;



    CustomizeMode(Integer id, String name){
        this.id = id;
        this.name = name;
    }

    /**
     * 根据Code获取描述
     * @param id
     * @return
     */
    public static CustomizeMode getValue(Integer id){
        for(CustomizeMode value : CustomizeMode.values()){
            if(value.getId().equals(id)){
                return value;
            }
        }
        return null;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }

}
