package com.thebeastshop.support.vo.customize;

import java.io.Serializable;
import java.util.List;

/**
 * 定制预览图片
 * Created by feilong.gao on 2016/12/12.
 */
public class CustomPreviewImage implements Serializable {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 1L;

    /**
     * 图片
     */
    private List<CustomImage> images;

    /**
     * 定制维度中定制元素列表
     * Array.index = 元素数组id ，group[index].value = 定制元素Array<CustomChoice>索引
     */
    private List<Long> group;

    public List<CustomImage> getImages() {
        return images;
    }

    public void setImages(List<CustomImage> images) {
        this.images = images;
    }

    public List<Long> getGroup() {
        return group;
    }

    public void setGroup(List<Long> group) {
        this.group = group;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("CustomPreviewImage{");
        sb.append("images=").append(images);
        sb.append(", group=").append(group);
        sb.append('}');
        return sb.toString();
    }
}
