package com.thebeastshop.support.encode;

import com.thebeastshop.support.exception.UnknownException;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @author Liang Wenjian
 */
public class HashUtil {

    public static String sha512ToString(final String source) {
        return getString(sha512ToBytes(source));
    }

    public static String sha256ToString(final String source) {
        return getString(sha256ToBytes(source));
    }

    public static String sha1ToString(final String source) {
        return getString(sha1ToBytes(source));
    }

    public static String md5ToString(final String source) {
        return getString(md5ToBytes(source));
    }

    public static String getString(final byte[] b) {
        final StringBuilder sb = new StringBuilder();
        for (final byte element : b) {
            final int i = element & 0xFF;
            if (i < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(i));
        }
        return sb.toString();
    }

    public static byte[] sha512ToBytes(final String source) {
        return hashToBytesCatchingException(source, "sha-512");
    }

    public static byte[] sha256ToBytes(final String source) {
        return hashToBytesCatchingException(source, "sha-256");
    }

    public static byte[] sha1ToBytes(final String source) {
        return hashToBytesCatchingException(source, "sha1");
    }

    public static byte[] md5ToBytes(final String source) {
        return hashToBytesCatchingException(source, "md5");
    }

    private static byte[] hashToBytesCatchingException(final String source, final String algorithm) {
        try {
            return hashToBytes(source, algorithm);
        } catch (final NoSuchAlgorithmException e) {
            throw new UnknownException("不支持" + algorithm + "这个算法", e);
        }
    }

    public static byte[] hashToBytes(final String source, final String algorithm) throws NoSuchAlgorithmException {
        return hashToBytes(source.getBytes(Encodes.UTF8.charset()), algorithm);
    }

    public static byte[] hashToBytes(final byte[] source, final String algorithm) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(algorithm).digest(source);
    }

    public static void main(final String... args) {
        final String s = "123456";
        System.out.println(md5ToString(s));
        System.out.println(sha1ToString(s));
        System.out.println(sha256ToString(s));
        System.out.println(sha512ToString(s));
    }

    private HashUtil() {
        super();
    }
}
