/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.exception;

import com.thebeastshop.support.exception.NetworkException;
import com.thebeastshop.support.exception.PlatErrInfo;
import com.thebeastshop.support.exception.PlatProblem;
import com.thebeastshop.support.mark.Retryable;

public class PlatNetworkException
extends NetworkException
implements PlatProblem,
Retryable {
    public static final String DEFAULT_MSG = "\u8c03\u7528{PLAT_NAME_PLACEHOLDER}\u5e73\u53f0\u63a5\u53e3\u65f6\u51fa\u73b0\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u5ba2\u670d\u3002";
    private static final long serialVersionUID = 1107836712614886538L;
    private final PlatErrInfo platErrInfo;
    private final int retryInterval;

    public PlatNetworkException(PlatErrInfo platErrInfo) {
        this(platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatNetworkException(PlatErrInfo platErrInfo, int retryInterval) {
        super(PlatProblem.PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo));
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatNetworkException(String message, PlatErrInfo platErrInfo) {
        this(message, platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatNetworkException(String message, PlatErrInfo platErrInfo, int retryInterval) {
        super(message);
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatNetworkException(String message, Throwable cause, PlatErrInfo platErrInfo) {
        this(message, cause, platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatNetworkException(String message, Throwable cause, PlatErrInfo platErrInfo, int retryInterval) {
        super(message, cause);
        this.platErrInfo = platErrInfo;
        this.retryInterval = retryInterval;
    }

    public PlatNetworkException(Throwable cause, PlatErrInfo platErrInfo) {
        this(cause, platErrInfo, DEFAULT_RETRY_INTERVAL);
    }

    public PlatNetworkException(Throwable cause, PlatErrInfo platErrInfo, int retryInterval) {
        this(PlatProblem.PlatProblemUtil.replaceParams(DEFAULT_MSG, platErrInfo), cause, platErrInfo, retryInterval);
    }

    @Override
    public int getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.hashCode() + ":{platName:'" + this.getPlatName() + '\'' + ", platErrCode:'" + this.getPlatErrCode() + '\'' + ", platErrMsg:'" + this.getPlatErrMsg() + '\'' + ", retryInterval:" + this.retryInterval + '}';
    }

    @Override
    public String getPlatName() {
        return this.platErrInfo.getPlatName();
    }

    @Override
    public String getPlatErrCode() {
        return this.platErrInfo.getPlatErrCode();
    }

    @Override
    public String getPlatErrMsg() {
        return this.platErrInfo.getPlatErrMsg();
    }

    @Override
    public int getMaxRetryTimes() {
        return 1;
    }
}

