package com.thebeastshop.support.vo.product;

import java.io.Serializable;
import java.math.BigDecimal;

import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.vo.product.ProductDetailNewVO.Image;

/**
 * 商品基础信息(since1.8)
 * 
 * @author WangYawei
 *
 */
public class ProductListVO {
	private ProductDiscount productDiscount;
	private Page<SimpleProductVO> list;
	private Suggest suggest;
	private Image banner;

	public Image getBanner() {
		return banner;
	}

	public void setBanner(Image banner) {
		this.banner = banner;
	}

	public ProductDiscount getProductDiscount() {
		return productDiscount;
	}

	public void setProductDiscount(ProductDiscount productDiscount) {
		this.productDiscount = productDiscount;
	}

	public Page<SimpleProductVO> getList() {
		return list;
	}

	public void setList(Page<SimpleProductVO> list) {
		this.list = list;
	}

	public Suggest getSuggest() {
		return suggest;
	}

	public void setSuggest(Suggest suggest) {
		this.suggest = suggest;
	}

	@Override
	public String toString() {
		return "ProductListVO [productDiscount =" + productDiscount + ", list =" + list + ", suggest =" + suggest
				+ ", banner =" + banner + "]";
	}

	/**
	 * 折扣
	 * 
	 * @author WangYawei
	 *
	 */

	public static class ProductDiscount implements Serializable {

		private BigDecimal ratio; // 折扣力度

		private String desc; // 一句话描述

		private String extendedDesc; // 如果有专享商品88折活动用{vipImage}间隔，如“大象会员9折丨含{vipImage}商品专享88折”

		private String linkText; // 享受专享88折时的右侧 “全部88折商品”

		private String link; // 全部专享商品对应的deeplink

		public BigDecimal getRatio() {
			return ratio;
		}

		public void setRatio(BigDecimal ratio) {
			this.ratio = ratio;
		}

		public String getDesc() {
			return desc;
		}

		public void setDesc(String desc) {
			this.desc = desc;
		}

		public String getExtendedDesc() {
			return extendedDesc;
		}

		public void setExtendedDesc(String extendedDesc) {
			this.extendedDesc = extendedDesc;
		}

		public String getLinkText() {
			return linkText;
		}

		public void setLinkText(String linkText) {
			this.linkText = linkText;
		}

		public String getLink() {
			return link;
		}

		public void setLink(String link) {
			this.link = link;
		}

		@Override
		public String toString() {
			return "ProductDiscount [ratio =" + ratio + ", desc =" + desc + ", extendedDesc =" + extendedDesc
					+ ", linkText =" + linkText + ", link =" + link + "]";
		}

	}

	/**
	 * 推荐since 2.1.0
	 * 
	 * @author WangYawei
	 *
	 */

	public static class Suggest implements Serializable {

		private String link; // 跳转链接

		private String keyword; // 关键字

		public String getLink() {
			return link;
		}

		public void setLink(String link) {
			this.link = link;
		}

		public String getKeyword() {
			return keyword;
		}

		public void setKeyword(String keyword) {
			this.keyword = keyword;
		}

		@Override
		public String toString() {
			return "Suggest [link =" + link + ", keyword =" + keyword + "]";
		}

	}
}
