package com.thebeastshop.support.vo.flowerMonth;

import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.flowerMonth.SelectType;

import java.io.Serializable;
import java.util.List;

/**
 * 捆绑元素
 * @author GFL
 * @Date 2018/1/30 15:50.
 */
public class TiedDimensionVO implements Serializable {

    private static final long serialVersionUID = 2264811742331751089L;

    private String name;                  //附属元素名称
    private SelectType selectType;          // 选择类型类型
    private CartPackSource source;        //捆绑来源 `赠品|加价购 `
    private List<TiedChoiceVO> choices;       // 捆绑选项
    private String note;                      // 提示文案
    private Integer seq; //序号

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SelectType getSelectType() {
        return selectType;
    }

    public void setSelectType(SelectType selectType) {
        this.selectType = selectType;
    }

    public CartPackSource getSource() {
        return source;
    }

    public void setSource(CartPackSource source) {
        this.source = source;
    }

    public List<TiedChoiceVO> getChoices() {
        return choices;
    }

    public void setChoices(List<TiedChoiceVO> choices) {
        this.choices = choices;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Integer getSeq() {
        return seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("TiedDimensionVO{");
        sb.append("name='").append(name).append('\'');
        sb.append(", selectType=").append(selectType);
        sb.append(", source=").append(source);
        sb.append(", choices=").append(choices);
        sb.append(", note='").append(note).append('\'');
        sb.append(", seq=").append(seq);
        sb.append('}');
        return sb.toString();
    }
}
