package com.thebeastshop.support.encode;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import com.thebeastshop.support.exception.UnknownException;

/**
 * 使用HashUtil
 */
public class MD5Util {

	public static final String MD5 = "MD5";

	public static byte[] md5ToBytes(final String source, final Encodes encodes) throws IllegalArgumentException {
		try {
			final MessageDigest md = MessageDigest.getInstance(MD5);
			return md.digest(source.getBytes(encodes.getName()));
		} catch (final NoSuchAlgorithmException e) {
			// impossible
			throw new UnknownException("不支持MD5这个算法，不可能", e);
		} catch (final UnsupportedEncodingException e) {
			// impossible
			throw new UnknownException("不支持" + encodes + "，不可能", e);
		}
	}

	public static byte[] md5ToBytes(final String source) throws IllegalArgumentException {
		return md5ToBytes(source, Encodes.UTF8);
	}

	public static String md5ToHexString(final String source, final Encodes encodes) throws IllegalArgumentException {
		final byte[] b = md5ToBytes(source, encodes);
		final StringBuilder sb = new StringBuilder();
		for (final byte element : b) {
			final int i = element & 0xFF;
			if (i < 16) {
				sb.append("0");
			}
			sb.append(Integer.toHexString(i));
		}
		return sb.toString();
	}

	public static String md5ToHexString(final String source) throws IllegalArgumentException {
		return md5ToHexString(source, Encodes.UTF8);
	}
}
