package com.thebeastshop.support.vo.product;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.thebeastshop.support.vo.product.SimpleProductVO.DiscVO;

/**
 * @author Paul-xiong
 */
public class SpvVO implements Serializable {

    private static final long serialVersionUID = 3525809972231619743L;

    private Long id;
    /**
     * 剩余库存量
     */
    private Integer left;
    /**
     * 默认图片
     */
    private String image;
    /**
     * 品牌
     */
    private BrandVO brand = new BrandVO();
    /**
     * 最小购买数量，默认为 1
     */
    private int minAmount = 1;
    /**
     * 原价
     */
    private BigDecimal rawPrice;
    /**
     * 折扣价
     */
    private BigDecimal price;

    /**
     * 积分价
     */
    private BigDecimal pointPrice;

    /**
     * 兑换积分
     */
    private Integer point;

    /**
     * 兑换会员等级
     */
    private List<Integer> levelIds;

    /**
     * 规格维度的选项组合
     */
    private Collection<Integer> group;
    /**
     * 一句话推荐
     */
    private String summary;
    /**
     * 描述
     */
    private String spvDesc;
    /**
     * 名称
     */
    private String name;
    /**
     * skuCodes（XXX:临时需要,以后可能会移除）
     */
    private List<String> skuCodes;
    /**
     * 商品 code（XXX:临时需要,以后可能会移除）
     */
    private String productCode;
    /**
     * 配送日期
     */
    private List<String> deliveryDates;
    /**
     * 第一次配送日期
     */
    private String firstDeliveryDate;
    /**
     * 是否低价销售
     */
    private boolean cheap = false;
    /**
     * 是否组合
     */
    private boolean combined = false;
    /**
     * 组合搭配商品
     */
    private boolean combination = false;

    private List<SpvVO> combinedSingleSpvs;
    /**
     * 可购买限额
     */
    private Quota quota;
    /**
     * 是否为预售商品，若不是预售，则为 null
     */
    private PreSellVO presell;
    /**
     * 预计发货
     */
    private PreDeliverVO preDeliver;
    /**
     * APP专享价
     */
    private DiscVO discount;
    /**
     * 闪购
     */
    private FlashSaleVO flashSale;
    
    /**
     * 安装描述
     */
    private String installDesc;
    
    /**
     * 是否海淘
     */
    private Boolean isOversea = false;

    public static long getSerialversionuid() {
        return serialVersionUID;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getLeft() {
        return left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getSpvDesc() {
        return spvDesc;
    }

    public void setSpvDesc(String spvDesc) {
        this.spvDesc = spvDesc;
    }

    public BrandVO getBrand() {
        return brand;
    }

    public void setBrand(BrandVO brand) {
        this.brand = brand;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getRawPrice() {
        return rawPrice;
    }

    public void setRawPrice(BigDecimal rawPrice) {
        this.rawPrice = rawPrice;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPointPrice() {
        return pointPrice;
    }

    public void setPointPrice(BigDecimal pointPrice) {
        this.pointPrice = pointPrice;
    }

    public Integer getPoint() {
        return point;
    }

    public void setPoint(Integer point) {
        this.point = point;
    }

    public List<Integer> getLevelIds() {
        return levelIds;
    }

    public void setLevelIds(List<Integer> levelIds) {
        this.levelIds = levelIds;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public int getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(int minAmount) {
        this.minAmount = minAmount;
    }

    public Collection<Integer> getGroup() {
        return group;
    }

    public void setGroup(Collection<Integer> group) {
        this.group = group;
    }

    public List<String> getDeliveryDates() {
        return deliveryDates;
    }

    public void setDeliveryDates(List<String> deliveryDates) {
        this.deliveryDates = deliveryDates;
    }

    public String getFirstDeliveryDate() {
        return firstDeliveryDate;
    }

    public void setFirstDeliveryDate(String firstDeliveryDate) {
        this.firstDeliveryDate = firstDeliveryDate;
    }

    public boolean isCheap() {
        return cheap;
    }

    public void setCheap(boolean cheap) {
        this.cheap = cheap;
    }

    public boolean isCombined() {
        return combined;
    }

    public void setCombined(boolean combined) {
        this.combined = combined;
    }

    public boolean isCombination() {
        return combination;
    }

    public void setCombination(boolean combination) {
        this.combination = combination;
    }

    public List<SpvVO> getCombinedSingleSpvs() {
        return combinedSingleSpvs;
    }

    public void setCombinedSingleSpvs(List<SpvVO> combinedSingleSpvs) {
        this.combinedSingleSpvs = combinedSingleSpvs;
    }

    public Quota getQuota() {
        return quota;
    }

    public void setQuota(Quota quota) {
        this.quota = quota;
    }

    public PreSellVO getPresell() {
        return presell;
    }

    public void setPresell(PreSellVO presell) {
        this.presell = presell;
    }

    public PreDeliverVO getPreDeliver() {
		return preDeliver;
	}

	public void setPreDeliver(PreDeliverVO preDeliver) {
		this.preDeliver = preDeliver;
	}

	public FlashSaleVO getFlashSale() {
        return flashSale;
    }

    public void setFlashSale(FlashSaleVO flashSale) {
        this.flashSale = flashSale;
    }

    public DiscVO getDiscount() {
        return discount;
    }

    public void setDiscount(DiscVO discount) {
        this.discount = discount;
    }
    
    public String getInstallDesc() {
		return installDesc;
	}

	public void setInstallDesc(String installDesc) {
		this.installDesc = installDesc;
	}
	
	public Boolean getIsOversea() {
		return isOversea;
	}

	public void setIsOversea(Boolean isOversea) {
		this.isOversea = isOversea;
	}

	@Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("SpvVO{");
        sb.append("discount=").append(discount);
        sb.append(", flashSale=").append(flashSale);
        sb.append(", presell=").append(presell);
        sb.append(", preDeliver=").append(preDeliver);
        sb.append(", id=").append(id);
        sb.append(", left=").append(left);
        sb.append(", image='").append(image).append('\'');
        sb.append(", brand=").append(brand);
        sb.append(", minAmount=").append(minAmount);
        sb.append(", rawPrice=").append(rawPrice);
        sb.append(", price=").append(price);
        sb.append(", levelIds=").append(levelIds);
        sb.append(", pointPrice=").append(pointPrice);
        sb.append(", point=").append(point);
        sb.append(", group=").append(group);
        sb.append(", summary='").append(summary).append('\'');
        sb.append(", spvDesc='").append(spvDesc).append('\'');
        sb.append(", name='").append(name).append('\'');
        sb.append(", skuCodes=").append(skuCodes);
        sb.append(", productCode='").append(productCode).append('\'');
        sb.append(", deliveryDates=").append(deliveryDates);
        sb.append(", firstDeliveryDate='").append(firstDeliveryDate).append('\'');
        sb.append(", cheap=").append(cheap);
        sb.append(", combined=").append(combined);
        sb.append(", installDesc=").append(installDesc);
        sb.append(", isOversea=").append(isOversea);
        sb.append(", quota=").append(quota);
        sb.append('}');
        return sb.toString();
    }

    /**
     * 品牌
     *
     * @author Paul-xiong
     */
    public static class BrandVO implements Serializable {
        /**
         *
         */
        private static final long serialVersionUID = 1L;
        private long id;
        private String name = "";

        public long getId() {
            return id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }
        
        public BrandVO() {
        	super();
        }
        
        public BrandVO(long id, String name) {
        	this.id = id;
        	this.name = name;
        }

        @Override
        public String toString() {
            return "BrandVO [id=" + id + ", name=" + name + "]";
        }

    }

    /**
     * 可购买限额
     *
     * @author ztq
     */
    public static class Quota implements Serializable {
        private static final long serialVersionUID = 1L;
        /**
         * 当前剩下的可购买额度
         */
        private int left = -1;
        /**
         * 总可购买额度
         */
        private int total = -1;

        public int getLeft() {
            return left;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public int getTotal() {
            return total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

    }

    /**
     * 闪购
     *
     * @author Yawei-wang
     */
    public static class FlashSaleVO implements Serializable {

        /**
         * @Field long serialVersionUID
         */
        private static final long serialVersionUID = 1L;

        /**
         * 如果不是闪购，或者闪购有效期之外，则为 null
         */
        private Timestamp expiresAt;// 单位秒，距离闪购结束的时间

        private boolean soldOut;// 闪购限额已经售光。如果在闪购有效期内，且闪购限额已经售光，则商品不能购买，显示为
        // soldout。

        public boolean isSoldOut() {
            return soldOut;
        }

        public Timestamp getExpiresAt() {
            return expiresAt;
        }

        public void setExpiresAt(Timestamp expiresAt) {
            this.expiresAt = expiresAt;
        }

        public void setSoldOut(boolean soldOut) {
            this.soldOut = soldOut;
        }

        @Override
        public String toString() {
            return "FlashSaleVO [expiresAt =" + expiresAt + ", soldOut =" + soldOut + "]";
        }
    }
    
    /**
     * 预计发货
     * @author xiang.gao
     * @date 2019/02/14
     */
    public static class PreDeliverVO implements Serializable{
    	/**
		 *
		 */
		private static final long serialVersionUID = 1L;
		/**
    	 * 0:预售 1:来单
    	 */
    	private Integer type;
    	/**
    	 * 预计发货时间
    	 */
    	private Date deliverAt;
    	/**
    	 * 发货信息描述
    	 */
    	private String content;

    	public Integer getType() {
    		return type;
    	}

    	public void setType(Integer type) {
    		this.type = type;
    	}

    	public Date getDeliverAt() {
    		return deliverAt;
    	}

    	public void setDeliverAt(Date deliverAt) {
    		this.deliverAt = deliverAt;
    	}

    	public String getContent() {
    		return content;
    	}

    	public void setContent(String content) {
    		this.content = content;
    	}
    }
    
}
