package com.thebeastshop.support.vo.cart;

import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.CartGroupType;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 分组vo
 * create by com.thebeastshop.support.vo.cart trunk :author lijing
 * User:lijing
 * DATE : 2016/8/15
 * TIME : 10:52
 * trunk.
 */
public class GroupsVO implements Serializable{
    /**标题*/
    private String title;
   /**描述*/
    private String description;
    /**若为 true，表明该 group 的商品，不能与其他 group 同时选中。海外购的 group，该值设置为 true*/
    private Boolean exclusive;
    /**
     * 商品包
     */
    private List<CartProductPackVO> packs;

    private CartGroupType type;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getExclusive() {
        return exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public List<CartProductPackVO> getPacks() {
        return packs;
    }

    public void setPacks(List<CartProductPackVO> packs) {
        this.packs = packs;
    }


    public CartGroupType getType() {
        return type;
    }

    public void setType(CartGroupType type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("title", title)
                .append("description", description)
                .append("exclusive", exclusive)
                .append("packs", packs)
                .append("type", type)
                .toString();
    }
}
