package com.thebeastshop.support.util.label;

import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.support.enums.label.LabelLink;
import org.apache.commons.lang3.StringUtils;

/**
 * 得到label的商品跳转详情link
 * create by com.thebeastshop.support.util.label trunk :author lijing
 * User:lijing
 * DATE : 2016/8/17
 * TIME : 13:18
 * trunk.
 */
public class LabelLinkUtil {
    /**
     * 通过productcode 和登录方式得到跳转商品详情连接
     * @param productCode
     * @param accessWay
     * @return
     */
    public static String getProductLink(String productCode , AccessWayEnum accessWay){
        String str = "";
        if(null != accessWay && StringUtils.isNotBlank(productCode)){
           if(AccessWayEnum.UNKNOWN.equals(accessWay)){

           }
            if(AccessWayEnum.PC.equals(accessWay)){
                str = LabelLink.PC_LINK.getMessage() + productCode + ".htm";
            }
            if(AccessWayEnum.APP.equals(accessWay)){

            }
            if(AccessWayEnum.WAP.equals(accessWay)){
                str = LabelLink.WAP_LINK.getMessage() + productCode + ".htm";
            }
        }
        return str;
    }
}
