package com.thebeastshop.support.enums;

/**
 * 订单卡片类型 0不需要1空白2代写
 */
public enum OrderCardType {
	NONE(0, "不需要"),

	EMPTY(1, "空白"),

	WRITE(2, "代写"),

	VOICE(3, "语音卡");

	private Integer code;
	private String desc;

	OrderCardType(Integer code, String desc) {
		this.code = code;
		this.desc = desc;
	}

	public Integer getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}

	/**
	 * 根据Code获取描述
	 * 
	 * @param code
	 * @return
	 */
	public static OrderCardType getByCode(Integer code) {
		for (OrderCardType value : OrderCardType.values()) {
			if (value.getCode().equals(code)) {
				return value;
			}
		}
		return OrderCardType.NONE;
	}
}
