package com.thebeastshop.support.enums.Customize;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.google.common.collect.Lists;

/**
 * 支持类型(0:小写字母 1:大写字母 2:数字 3:表情） Created by GFL on 2017/5/15.
 */
public enum LimitType {

	LOWER("0", "小写字母", "a-z"), UPPER("1", "大写字母", "A-Z"), NUMBER("2", "数字", "0-9"), HEART_SYMBOL("3", "爱心表情",
			"(\\[\\[love\\]\\])*"), POINT_SYMBOL("4", "英文点字符", "."), SMILE_SYMBOL("5", "笑脸表情",
					"(\\[\\[smile\\]\\])*"), ARROW_HEART_SYMBOL("6", "一箭穿心表情",
							"(\\[\\[arrowheart\\]\\])*"), POINT_MIDDLE_SYMBOL("7", "英文中间点字符", "•"), LB_PHONE_SYMBOL("8",
									"手机", "(\\[\\[lbphone\\]\\])*"), LB_BULB_SYMBOL("9", "灯泡",
											"(\\[\\[lbbulb\\]\\])*"), LB_AIRPLANE_SYMBOL("10", "飞机",
													"(\\[\\[lbairplane\\]\\])*"), LB_SUNGLASSES_SYMBOL("11", "墨镜",
															"(\\[\\[lbsunglasses\\]\\])*"), LB_FLASH_SYMBOL("12", "闪电",
																	"(\\[\\[lbflash\\]\\])*"), LB_STAR_SYMBOL("13",
																			"五角星",
																			"(\\[\\[lbstar\\]\\])*"), LB_BICYCLE_SYMBOL(
																					"14", "自行车",
																					"(\\[\\[lbbicycle\\]\\])*"), LB_BOY_SYMBOL(
																							"15", "男孩",
																							"(\\[\\[lbboy\\]\\])*"), LB_GIRL_SYMBOL(
																									"16", "女孩",
																									"(\\[\\[lbgirl\\]\\])*"), LB_OK_SYMBOL(
																											"17", "ok",
																											"(\\[\\[lbok\\]\\])*"),;

	private String code;
	private String value;
	private String regEx;

	private LimitType(String code, String value, String regEx) {
		this.code = code;
		this.value = value;
		this.regEx = regEx;
	}

	public String getCode() {
		return code;
	}

	public String getValue() {
		return value;
	}

	public String getRegEx() {
		return regEx;
	}

	/**
	 * 根据Code获取枚举
	 * 
	 * @param code
	 * @return
	 */
	public static LimitType getLimitTypeByCode(String code) {
		for (LimitType value : LimitType.values()) {
			if (StringUtils.equals(value.getCode(), code)) {
				return value;
			}
		}
		return null;
	}

	/**
	 * 根据Code获取枚举
	 * 
	 * @param codes
	 * @return
	 */
	public static List<LimitType> getLimitTypeByCodes(List<String> codes) {
		if (null == codes) {
			return null;
		}
		List<LimitType> limitTypes = Lists.newArrayList();
		for (String code : codes) {
			LimitType limitType = getLimitTypeByCode(code);
			if (null != limitType) {
				limitTypes.add(limitType);
			}
		}
		return limitTypes;
	}

	public static String getRegEx(List<LimitType> limitTypes) {
		boolean isHeartSymbol = false;
		boolean isSmileSymbol = false;
		boolean isArrowHeartSymbol = false;

		boolean isPhone = false;
		boolean isBulb = false;
		boolean isAirplane = false;
		boolean isSunglass = false;
		boolean isFlash = false;
		boolean isStar = false;
		boolean isBicycle = false;
		boolean isBoy = false;
		boolean isGirl = false;
		boolean isOk = false;

		StringBuffer regEx = new StringBuffer();
		StringBuffer regEx1 = new StringBuffer();
		for (LimitType limitType : limitTypes) {
			if (LimitType.HEART_SYMBOL.equals(limitType)) {
				isHeartSymbol = true;
			} else if (LimitType.SMILE_SYMBOL.equals(limitType)) {
				isSmileSymbol = true;
			} else if (LimitType.ARROW_HEART_SYMBOL.equals(limitType)) {
				isArrowHeartSymbol = true;
			}

			else if (LimitType.LB_PHONE_SYMBOL.equals(limitType)) {
				isPhone = true;
			} else if (LimitType.LB_BULB_SYMBOL.equals(limitType)) {
				isBulb = true;
			} else if (LimitType.LB_AIRPLANE_SYMBOL.equals(limitType)) {
				isAirplane = true;
			} else if (LimitType.LB_SUNGLASSES_SYMBOL.equals(limitType)) {
				isSunglass = true;
			} else if (LimitType.LB_FLASH_SYMBOL.equals(limitType)) {
				isFlash = true;
			} else if (LimitType.LB_STAR_SYMBOL.equals(limitType)) {
				isStar = true;
			} else if (LimitType.LB_BICYCLE_SYMBOL.equals(limitType)) {
				isBicycle = true;
			} else if (LimitType.LB_BOY_SYMBOL.equals(limitType)) {
				isBoy = true;
			} else if (LimitType.LB_GIRL_SYMBOL.equals(limitType)) {
				isGirl = true;
			} else if (LimitType.LB_OK_SYMBOL.equals(limitType)) {
				isOk = true;
			}

			else {
				regEx1.append(limitType.getRegEx());
			}
		}
		if (StringUtils.isNotEmpty(regEx1)) {
			regEx1.insert(0, "[");
			regEx1.append("]*");
		}
		regEx.append("^(");
		regEx.append(regEx1);
		if (isHeartSymbol) {
			regEx.append(LimitType.HEART_SYMBOL.getRegEx());
		}
		if (isSmileSymbol) {
			regEx.append(LimitType.SMILE_SYMBOL.getRegEx());
		}
		if (isArrowHeartSymbol) {
			regEx.append(LimitType.ARROW_HEART_SYMBOL.getRegEx());
		}

		if (isPhone) {
			regEx.append(LimitType.LB_PHONE_SYMBOL.getRegEx());
		}
		if (isBulb) {
			regEx.append(LimitType.LB_BULB_SYMBOL.getRegEx());
		}
		if (isAirplane) {
			regEx.append(LimitType.LB_AIRPLANE_SYMBOL.getRegEx());
		}
		if (isSunglass) {
			regEx.append(LimitType.LB_SUNGLASSES_SYMBOL.getRegEx());
		}
		if (isFlash) {
			regEx.append(LimitType.LB_FLASH_SYMBOL.getRegEx());
		}
		if (isStar) {
			regEx.append(LimitType.LB_STAR_SYMBOL.getRegEx());
		}
		if (isBicycle) {
			regEx.append(LimitType.LB_BICYCLE_SYMBOL.getRegEx());
		}
		if (isBoy) {
			regEx.append(LimitType.LB_BOY_SYMBOL.getRegEx());
		}
		if (isGirl) {
			regEx.append(LimitType.LB_GIRL_SYMBOL.getRegEx());
		}
		if (isOk) {
			regEx.append(LimitType.LB_OK_SYMBOL.getRegEx());
		}

		regEx.append(")*$");
		return regEx.toString();
	}

}
