package com.thebeastshop.support;

import java.io.Serializable;

import com.thebeastshop.support.mark.Type;
import com.thebeastshop.support.mark.Validatable;

/**
 * @author Liang Wenjian
 */
public class Label implements Validatable, Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private LabelMode mode = LabelMode.TEXT;
	private String type;
	private String typeColor;
	private String typeBgColor = "#000000";
	private String summary;
	private String summaryColor = "#000000";
	private String link;
	private Integer count;
	private boolean valid = true;
	private boolean jump = true;
	private CampaignVO campaign;
	private PostageVO postage;

	public Label() {
		super();
	}

	public Label(String type, String typeColor, String typeBgColor, String summary, String summaryColor, String link,
			Integer count, boolean valid) {
		super();
		this.type = type;
		this.typeColor = typeColor;
		this.typeBgColor = typeBgColor;
		this.summary = summary;
		this.summaryColor = summaryColor;
		this.link = link;
		this.count = count;
		this.valid = valid;
	}

	public LabelMode getMode() {
		return mode;
	}

	public void setMode(LabelMode mode) {
		this.mode = mode;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(final String summary) {
		this.summary = summary;
	}

	@Override
	public boolean isValid() {
		return valid;
	}

	public void setValid(final boolean valid) {
		this.valid = valid;
	}

	public String getLink() {
		return link;
	}

	public void setLink(final String link) {
		this.link = link;
	}

	public Integer getCount() {
		return count;
	}

	public void setCount(final Integer count) {
		this.count = count;
	}

	public boolean isJump() {
		return jump;
	}

	public void setJump(boolean jump) {
		this.jump = jump;
	}

	public String getSummaryColor() {
		return summaryColor;
	}

	public void setSummaryColor(final String summaryColor) {
		this.summaryColor = summaryColor;
	}

	public String getTypeColor() {
		return typeColor;
	}

	public void setTypeColor(String typeColor) {
		this.typeColor = typeColor;
	}

	public String getTypeBgColor() {
		return typeBgColor;
	}

	public void setTypeBgColor(String typeBgColor) {
		this.typeBgColor = typeBgColor;
	}

	public CampaignVO getCampaign() {
		return campaign;
	}

	public void setCampaign(CampaignVO campaign) {
		this.campaign = campaign;
	}

	public PostageVO getPostage() {
		return postage;
	}

	public void setPostage(PostageVO postage) {
		this.postage = postage;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + hashCode() + ":{" + "type:'" + type + '\'' + ", summary:'" + summary + '\''
				+ ", valid:" + valid + ", link:'" + link + '\'' + ", count:" + count + ", summaryColor:'" + summaryColor
				+ '\'' + '}';
	}

	public static class PostageVO implements Serializable {

		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		private Boolean fulfilled = false;

		private String linkDesc;

		public Boolean getFulfilled() {
			return fulfilled;
		}

		public void setFulfilled(Boolean fulfilled) {
			this.fulfilled = fulfilled;
		}

		public String getLinkDesc() {
			return linkDesc;
		}

		public void setLinkDesc(String linkDesc) {
			this.linkDesc = linkDesc;
		}

		@Override
		public String toString() {
			return "PostageVO [fulfilled=" + fulfilled + ", linkDesc=" + linkDesc + "]";
		}

	}

	public static class CampaignVO implements Serializable {

		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		private Long id;

		private String name;

		private Boolean fulfilled = false;

		private String linkDesc;

		public Long getId() {
			return id;
		}

		public void setId(Long id) {
			this.id = id;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public Boolean getFulfilled() {
			return fulfilled;
		}

		public void setFulfilled(Boolean fulfilled) {
			this.fulfilled = fulfilled;
		}

		public String getLinkDesc() {
			return linkDesc;
		}

		public void setLinkDesc(String linkDesc) {
			this.linkDesc = linkDesc;
		}

		@Override
		public String toString() {
			return "CampaignVO [id=" + id + ", name=" + name + ", fulfilled=" + fulfilled + ", linkDesc=" + linkDesc
					+ "]";
		}

	}

	public static enum LabelMode implements Type {
		TEXT(1, "文本"), POSTAGE(2, "邮费"), CAMPAIGN(3, "活动"),;

		private final int id;
		private final String name;

		LabelMode(final int id, final String name) {
			this.id = id;
			this.name = name;
		}

		@Override
		public Integer getId() {
			return id;
		}

		@Override
		public String getName() {
			return name;
		}

	}

}
