/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.mark;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.thebeastshop.support.mark.HasNameCons;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public interface HasName
extends HasNameCons {
    public static final String PROPERTY_NAME = "name";

    public String getName();

    public static class NameUtil
    implements HasNameCons {
        public static <T extends HasName> Collection<String> toNames(Collection<T> source) {
            return Collections2.transform(source, (Function)TO_NAME);
        }

        public static <T extends HasName> Map<String, T> map(Iterable<T> source) {
            HashMap map = Maps.newHashMap();
            for (HasName t : source) {
                map.put(t.getName(), t);
            }
            return map;
        }

        public static <T extends HasName> T findByName(T target, Collection<? extends T> source) {
            return NameUtil.findByName(target.getName(), source);
        }

        public static <T extends HasName> T findByName(String name, Collection<? extends T> source) {
            for (HasName t : source) {
                if (!t.getName().equals(name)) continue;
                return (T)t;
            }
            return null;
        }

        private NameUtil() {
        }
    }
}

