/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.exception;

import com.thebeastshop.support.exception.BaseException;
import com.thebeastshop.support.vo.NameValuePair;
import java.util.Arrays;

public class WrongArgException
extends BaseException {
    private static final long serialVersionUID = -5954465849908546225L;
    private final NameValuePair[] args;

    public WrongArgException(String argName, Object actualValue) {
        super(WrongArgException.replaceParams(argName, actualValue), NEXT_STEP_IDS_OF_RETRY);
        this.args = new NameValuePair[]{new NameValuePair(argName, actualValue)};
    }

    public WrongArgException(String message, String argName, Object actualValue) {
        super(message, NEXT_STEP_IDS_OF_RETRY);
        this.args = new NameValuePair[]{new NameValuePair(argName, actualValue)};
    }

    public WrongArgException(Throwable cause, String argName, Object actualValue) {
        this(WrongArgException.replaceParams(argName, actualValue), cause, argName, actualValue);
    }

    public WrongArgException(String message, Throwable cause, String argName, Object actualValue) {
        super(message, cause, NEXT_STEP_IDS_OF_RETRY);
        this.args = new NameValuePair[]{new NameValuePair(argName, actualValue)};
    }

    public WrongArgException(NameValuePair ... args) {
        this(WrongArgException.replaceParams(args), args);
    }

    public WrongArgException(String message, NameValuePair ... args) {
        super(message, NEXT_STEP_IDS_OF_RETRY);
        this.args = args;
    }

    public WrongArgException(String message, Throwable cause, NameValuePair ... args) {
        super(message, cause, NEXT_STEP_IDS_OF_RETRY);
        this.args = args;
    }

    public NameValuePair[] getArgs() {
        return this.args;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + this.hashCode() + ":{args:'" + Arrays.toString(this.args) + "'}";
    }

    protected static String replaceParams(NameValuePair ... args) {
        StringBuilder sb = new StringBuilder();
        for (NameValuePair arg : args) {
            String argName = arg.getName();
            Object actualValue = arg.getValue();
            sb.append("\u53c2\u6570\u201c").append(argName).append("\u201d\u503c\u201c").append(actualValue).append("\u201d\u6709\u8bef\uff0c");
        }
        return sb.append("\u8bf7\u4fee\u6b63\u540e\u91cd\u65b0\u8bf7\u6c42\u3002").toString();
    }

    protected static String replaceParams(String argName, Object actualValue) {
        return "\u53c2\u6570\u201c" + argName + "\u201d\u503c\u201c" + actualValue + "\u201d\u6709\u8bef\uff0c\u8bf7\u4fee\u6b63\u540e\u91cd\u65b0\u8bf7\u6c42\u3002";
    }
}

