/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.support.encode;

import com.thebeastshop.support.encode.Base64Util;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;

public class RSAUtil {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final String SIGN_TYPE_RSA = "RSA";

    public static String rsaEncrypt(String content, String publicKey, String charset) throws Exception {
        PublicKey pubKey = RSAUtil.getPublicKeyFromX509(SIGN_TYPE_RSA, publicKey);
        Cipher cipher = Cipher.getInstance(SIGN_TYPE_RSA);
        cipher.init(1, pubKey);
        byte[] data = StringUtils.isEmpty((CharSequence)charset) ? content.getBytes() : content.getBytes(charset);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        String encryptedData = Base64Util.encode(out.toByteArray());
        out.close();
        return encryptedData;
    }

    public static String rsaDecrypt(String content, String privateKey, String charset) throws Exception {
        PrivateKey priKey = RSAUtil.getPrivateKeyFromPKCS8(SIGN_TYPE_RSA, privateKey);
        Cipher cipher = Cipher.getInstance(SIGN_TYPE_RSA);
        cipher.init(2, priKey);
        byte[] encryptedData = StringUtils.isEmpty((CharSequence)charset) ? Base64Util.decode(new String(content.getBytes())) : Base64Util.decode(new String(content.getBytes(charset)));
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return StringUtils.isEmpty((CharSequence)charset) ? new String(decryptedData) : new String(decryptedData, charset);
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, String privateKey) throws Exception {
        if (StringUtils.isEmpty((CharSequence)algorithm) || StringUtils.isEmpty((CharSequence)privateKey)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePublic(new X509EncodedKeySpec(Base64Util.decode(privateKey)));
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, String privateKey) throws Exception {
        if (StringUtils.isEmpty((CharSequence)algorithm) || StringUtils.isEmpty((CharSequence)privateKey)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64Util.decode(privateKey)));
    }
}

