package com.thebeastshop.support.vo.weixin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.thebeastshop.support.vo.operation.Share;
import com.thebeastshop.support.vo.product.SimpleProductVO;

/**
 * 微信首页
 * 
 * @author WangYawei
 *
 */
public class WxIndexVO implements Serializable {

	private Long indexId;

	private String title;

	private Share share = new Share();

	private List<Module> modules = new ArrayList<Module>();

	
	
	public Long getIndexId() {
		return indexId;
	}

	public void setIndexId(Long indexId) {
		this.indexId = indexId;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Share getShare() {
		return share;
	}

	public void setShare(Share share) {
		this.share = share;
	}

	public List<Module> getModules() {
		return modules;
	}

	public void setModules(List<Module> modules) {
		this.modules = modules;
	}

	public static class Module {
		private String type = "";
		private Object data = new Object();

		public String getType() {
			return type;
		}

		public void setType(String type) {
			this.type = type;
		}

		public Object getData() {
			return data;
		}

		public void setData(Object data) {
			this.data = data;
		}

		@Override
		public String toString() {
			return new ToStringBuilder(this).append("type", type).append("data", data).toString();
		}
	}

	public static class Base {

	}

	public static class Image extends Base {
		private String width;
		private String height;
		private String src;

		public String getWidth() {
			return width;
		}

		public void setWidth(String width) {
			this.width = width;
		}

		public String getHeight() {
			return height;
		}

		public void setHeight(String height) {
			this.height = height;
		}

		public String getSrc() {
			return src;
		}

		public void setSrc(String src) {
			this.src = src;
		}

		@Override
		public String toString() {
			return new ToStringBuilder(this).append("width", width).append("height", height).append("src", src).toString();
		}

	}

	public static class ProductList extends Base {
		private String titleImage;
		private List<SimpleProductVO> products;

		public String getTitleImage() {
			return titleImage;
		}

		public void setTitleImage(String titleImage) {
			this.titleImage = titleImage;
		}

		public List<SimpleProductVO> getProducts() {
			return products;
		}

		public void setProducts(List<SimpleProductVO> products) {
			this.products = products;
		}

		@Override
		public String toString() {
			return new ToStringBuilder(this).append("titleImage", titleImage).append("products", products).toString();
		}
	}

	public static class Story extends Base {
		private String images;
		private String title;
		private String brief;
		private SimpleProductVO product;

		public String getImages() {
			return images;
		}

		public void setImages(String images) {
			this.images = images;
		}

		public String getTitle() {
			return title;
		}

		public void setTitle(String title) {
			this.title = title;
		}

		public String getBrief() {
			return brief;
		}

		public void setBrief(String brief) {
			this.brief = brief;
		}

		public SimpleProductVO getProduct() {
			return product;
		}

		public void setProduct(SimpleProductVO product) {
			this.product = product;
		}

		@Override
		public String toString() {
			return new ToStringBuilder(this).append("images", images).append("title", title).append("brief", brief).append("product", product).toString();
		}
	}

	// @Override
	// public String toString() {
	// return new ToStringBuilder(this).append("modules", modules).toString();
	// }

}
