package com.thebeastshop.support.vo.product;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.thebeastshop.support.Label;
import com.thebeastshop.support.vo.product.SpvVO.BrandVO;

/**
 * 商品基础信息
 * 
 * @author Paul-xiong
 *
 */
public class SimpleProductVO {
	private Boolean isOversea = false;
	private String id;
	private String featureImage = "";
	private List<String> images = new ArrayList<String>();
	private BrandVO brand;
	private String name;
	private String summary;
	private Boolean soldOut;
	private Boolean invisible;
	private Boolean offShelf;
	private List<Label> labels = new ArrayList<Label>();
	private BigDecimal price;
	private BigDecimal rawPrice;
	private List<String> waterMarkImage;
	private DiscVO discount;
	private PriceForecastVO priceForecast;
	private Boolean rush;
	private Boolean monthSend = false;
	private String activityDesc;
	private Boolean vipOnly = false;// 专享商品
	private Boolean foretell = false;// 预告商品

	public Boolean getForetell() {
		return foretell;
	}

	public void setForetell(Boolean foretell) {
		this.foretell = foretell;
	}

	private Boolean hasPresale = false; // 是否预售

	public String getActivityDesc() {
		return activityDesc;
	}

	public void setActivityDesc(String activityDesc) {
		this.activityDesc = activityDesc;
	}

	/**
	 * 商品是否可定制
	 */
	private Boolean customizable = false;

	public Boolean getIsOversea() {
		return isOversea;
	}

	public void setIsOversea(Boolean isOversea) {
		this.isOversea = isOversea;
	}

	public Boolean getCustomizable() {
		return customizable;
	}

	public void setCustomizable(Boolean customizable) {
		this.customizable = customizable;
	}

	public Boolean getRush() {
		return rush;
	}

	public void setRush(Boolean rush) {
		this.rush = rush;
	}

	public PriceForecastVO getPriceForecast() {
		return priceForecast;
	}

	public void setPriceForecast(PriceForecastVO priceForecast) {
		this.priceForecast = priceForecast;
	}

	public DiscVO getDiscount() {
		return discount;
	}

	public void setDiscount(DiscVO discount) {
		this.discount = discount;
	}

	public SimpleProductVO() {
		super();
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getFeatureImage() {
		return featureImage;
	}

	public void setFeatureImage(String featureImage) {
		this.featureImage = featureImage;
	}

	public List<String> getImages() {
		return images;
	}

	public void setImages(List<String> images) {
		this.images = images;
	}

	public BrandVO getBrand() {
		return brand;
	}

	public void setBrand(BrandVO brand) {
		this.brand = brand;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	public BigDecimal getRawPrice() {
		return rawPrice;
	}

	public void setRawPrice(BigDecimal rawPrice) {
		this.rawPrice = rawPrice;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public Boolean getSoldOut() {
		return soldOut;
	}

	public void setSoldOut(Boolean soldOut) {
		this.soldOut = soldOut;
	}

	public Boolean getInvisible() {
		return invisible;
	}

	public void setInvisible(Boolean invisible) {
		this.invisible = invisible;
	}

	public Boolean getOffShelf() {
		return offShelf;
	}

	public void setOffShelf(Boolean offShelf) {
		this.offShelf = offShelf;
	}

	public List<Label> getLabels() {
		return labels;
	}

	public void setLabels(List<Label> labels) {
		this.labels = labels;
	}

	public List<String> getWaterMarkImage() {
		return waterMarkImage;
	}

	public void setWaterMarkImage(List<String> waterMarkImage) {
		this.waterMarkImage = waterMarkImage;
	}

	public Boolean getMonthSend() {
		return monthSend;
	}

	public void setMonthSend(Boolean monthSend) {
		this.monthSend = monthSend;
	}

	public Boolean getVipOnly() {
		return vipOnly;
	}

	public void setVipOnly(Boolean vipOnly) {
		this.vipOnly = vipOnly;
	}

	public Boolean getHasPresale() {
		return hasPresale;
	}

	public void setHasPresale(Boolean hasPresale) {
		this.hasPresale = hasPresale;
	}

	/**
	 * 折扣标签
	 * 
	 * @author Yawei-wang
	 *
	 */
	public static class DiscVO implements Serializable {

		/**
		 * 是否为 vip 折扣，若为抢购价，则为 false
		 */
		private String vipLevel;

		private boolean appOnly;

		private Boolean birthday;

		public Boolean isBirthday() {
			return birthday;
		}

		public void setBirthday(Boolean birthday) {
			this.birthday = birthday;
		}

		public String getVipLevel() {
			return vipLevel;
		}

		public void setVipLevel(String vipLevel) {
			this.vipLevel = vipLevel;
		}

		public boolean isAppOnly() {
			return appOnly;
		}

		public void setAppOnly(boolean appOnly) {
			this.appOnly = appOnly;
		}

		@Override
		public String toString() {
			return "DiscVO [vipLevel =" + vipLevel + ", appOnly =" + appOnly + ", birthday =" + birthday + "]";
		}

	}

	/**
	 * 预售价
	 * 
	 * @author Yawei-wang
	 *
	 */
	public static class PriceForecastVO implements Serializable {

		/**
		 * 开始时间
		 */
		private Timestamp since;
		/**
		 * 预告价名称：如 "圣诞狂欢季"
		 */
		private String name;
		/**
		 * 价格范围，若只有一种价格，则包含两个相同价格。
		 */
		private Collection<BigDecimal> range = new ArrayList<BigDecimal>();

		public Timestamp getSince() {
			return since;
		}

		public void setSince(Timestamp since) {
			this.since = since;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public Collection<BigDecimal> getRange() {
			return range;
		}

		public void setRange(Collection<BigDecimal> range) {
			this.range = range;
		}

		@Override
		public String toString() {
			return "PriceForecastVO [since =" + since + ", name =" + name + ", range =" + range + "]";
		}

	}

}
