package com.thebeastshop.support.vo.product;

import java.io.Serializable;
import java.util.ArrayList;

public class ProductDetailNewVO implements Serializable {

	private static final long serialVersionUID = 1L;

	private ArrayList<ProductDetail> details;

	public ArrayList<ProductDetail> getDetails() {
		return details;
	}

	public void setDetails(ArrayList<ProductDetail> details) {
		this.details = details;
	}

	public static class ProductDetail {

		private String titleEn;
		private String title;
		private Boolean expanded;
		private ArrayList<ProductDetailModule> modules;

		public Boolean getExpanded() {
			return expanded;
		}

		public void setExpanded(Boolean expanded) {
			this.expanded = expanded;
		}

		public String getTitleEn() {
			return titleEn;
		}

		public void setTitleEn(String titleEn) {
			this.titleEn = titleEn;
		}

		public String getTitle() {
			return title;
		}

		public void setTitle(String title) {
			this.title = title;
		}

		public ArrayList<ProductDetailModule> getModules() {
			return modules;
		}

		public void setModules(ArrayList<ProductDetailModule> modules) {
			this.modules = modules;
		}

		@Override
		public String toString() {
			return "ProductDetail [titleEn=" + titleEn + ", title=" + title + ", modules=" + modules + ", expanded="
					+ expanded + "]";
		}
	}

	public static class ProductDetailModule {

		private String type;
		private String title;
		private String text;
		private Image image;
		private String desc;
		private ArrayList<TableRow> table;
		private String link;

		public String getType() {
			return type;
		}

		public void setType(String type) {
			this.type = type;
		}

		public String getTitle() {
			return title;
		}

		public void setTitle(String title) {
			this.title = title;
		}

		public String getText() {
			return text;
		}

		public void setText(String text) {
			this.text = text;
		}

		public Image getImage() {
			return image;
		}

		public void setImage(Image image) {
			this.image = image;
		}

		public String getDesc() {
			return desc;
		}

		public void setDesc(String desc) {
			this.desc = desc;
		}

		public ArrayList<TableRow> getTable() {
			return table;
		}

		public void setTable(ArrayList<TableRow> table) {
			this.table = table;
		}

		public String getLink() {
			return link;
		}

		public void setLink(String link) {
			this.link = link;
		}

		@Override
		public String toString() {
			return "ProductDetailModule [type=" + type + ", title=" + title + ", text=" + text + ", image=" + image
					+ ", desc=" + desc + ", table=" + table + ", link=" + link + "]";
		}
	}

	public static class TableRow {

		private ArrayList<String> tableRow;

		public ArrayList<String> getTableRow() {
			return tableRow;
		}

		public void setTableRow(ArrayList<String> tableRow) {
			this.tableRow = tableRow;
		}

		@Override
		public String toString() {
			return "TableRow [tableRow=" + tableRow + "]";
		}
	}

	public static class Image implements Serializable {

		private Integer width;

		private Integer height;

		private String src;

		public Integer getWidth() {
			return width;
		}

		public void setWidth(Integer width) {
			this.width = width;
		}

		public Integer getHeight() {
			return height;
		}

		public void setHeight(Integer height) {
			this.height = height;
		}

		public String getSrc() {
			return src;
		}

		public void setSrc(String src) {
			this.src = src;
		}

		@Override
		public String toString() {
			return "Image [width =" + width + ", height =" + height + ", src =" + src + "]";
		}

	}

	@Override
	public String toString() {
		return "EmphasizeVO [details=" + details + "]";
	}

}
