package com.thebeastshop.support.vo.customize;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created by GFL on 2017/10/25.
 */
public class CustomPosition implements Serializable{

    private static final long serialVersionUID = 6806417268270192577L;

    private String  name;                  //定制区域名字
    private BigDecimal height;             // 定制区域高,单位px
    private BigDecimal width;              // 定制区域宽(长),单位px
    private BigDecimal fontSize;           // 字体大小,单位px
    private BigDecimal centralX;           // 中心坐标X,单位px
    private BigDecimal centralY;           // 中心坐标Y,单位px
    private Integer opacity;            // 不透明度,


    public CustomPosition() {
    }

    public CustomPosition(String name, BigDecimal height, BigDecimal width, BigDecimal fontSize, BigDecimal centralX, BigDecimal centralY) {
        this.name = name;
        this.height = height;
        this.width = width;
        this.fontSize = fontSize;
        this.centralX = centralX;
        this.centralY = centralY;
        this.opacity = 100;
    }

    public CustomPosition(String name, BigDecimal height, BigDecimal width, BigDecimal fontSize, BigDecimal centralX, BigDecimal centralY, Integer opacity) {
        this.name = name;
        this.height = height;
        this.width = width;
        this.fontSize = fontSize;
        this.centralX = centralX;
        this.centralY = centralY;
        this.opacity = opacity;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getHeight() {
        return height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public BigDecimal getWidth() {
        return width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getFontSize() {
        return fontSize;
    }

    public void setFontSize(BigDecimal fontSize) {
        this.fontSize = fontSize;
    }

    public BigDecimal getCentralX() {
        return centralX;
    }

    public void setCentralX(BigDecimal centralX) {
        this.centralX = centralX;
    }

    public BigDecimal getCentralY() {
        return centralY;
    }

    public void setCentralY(BigDecimal centralY) {
        this.centralY = centralY;
    }

    public Integer getOpacity() {
        return opacity;
    }

    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("CustomPosition{");
        sb.append("name='").append(name).append('\'');
        sb.append(", height=").append(height);
        sb.append(", width=").append(width);
        sb.append(", fontSize=").append(fontSize);
        sb.append(", centralX=").append(centralX);
        sb.append(", centralY=").append(centralY);
        sb.append(", opacity=").append(opacity);
        sb.append('}');
        return sb.toString();
    }
}
